This tests to make sure that all of the files generated by PLY are up to date.

    >>> import os.path
    >>> def check(src, dest):
    ...     assert os.path.getmtime(src) <= os.path.getmtime(dest), \
    ...            dest + " out of date"
    >>> check('scanner.py', 'scanner_tables.py')
    >>> check('scanner.py', 'krbparser_tables.py')
    >>> check('krbparser.py', 'krbparser_tables.py')
    >>> check('scanner.py', 'kfbparser_tables.py')
    >>> check('kfbparser.py', 'kfbparser_tables.py')

Check that compiler_bc.py is up to date:

    >>> if not os.path.isdir('compiled_krb'): os.mkdir('compiled_krb')

    >>> from pyke import krb_compiler
    >>> krb_compiler.compile_krb('compiler', 'compiled_krb', 'compiled_krb',
    ...                          'compiler.krb')
    ['compiler_bc.py']

    >>> from __future__ import with_statement
    >>> import re
    >>> del_krb_filename = re.compile(r"^Krb_filename = .*")
    >>> with open('compiler_bc.py') as f:
    ...     f1_text = del_krb_filename.sub('', f.read(), 1)
    >>> with open('compiled_krb/compiler_bc.py') as f:
    ...     f2_text = del_krb_filename.sub('', f.read(), 1)
    >>> assert f1_text == f2_text, "krb_compiler/compiler.krb not compiled"
    >>> if f1_text == f2_text: os.remove('compiled_krb/compiler_bc.py')
