/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.PgTypes
{
	[Serializable]
	public struct PgTimeSpan : IComparable
	{
		#region Fields

		private TimeSpan interval;

		#endregion

		#region Properties

		public int Days
		{
			get { return this.interval.Days; }
		}

		public int Hours
		{
			get { return this.interval.Hours; }
		}

		public int Milliseconds
		{
			get { return this.interval.Milliseconds; }
		}

		public int Minutes
		{
			get { return this.interval.Minutes; }
		}

		public int Seconds
		{
			get { return this.interval.Seconds; }
		}

		public TimeSpan Value
		{
			get { return interval; }
		}

		#endregion

		#region Static Fields

		public static readonly PgTimeSpan	MaxValue = new PgTimeSpan(TimeSpan.MaxValue);
		public static readonly PgTimeSpan	MinValue = new PgTimeSpan(TimeSpan.MinValue);
		public static readonly PgTimeSpan	Null	 = new PgTimeSpan(TimeSpan.Zero);

		#endregion

		#region Constructors

		public PgTimeSpan(TimeSpan interval)
		{
			this.interval = interval;
		}

		#endregion

		#region ICOMPARABLE

		public int CompareTo(object obj)
		{
			return interval.CompareTo(obj);
		}

		#endregion

		#region Static Methods

		public static bool GreatherThan(PgTimeSpan x, PgTimeSpan y)
		{
			return (x > y);
		}

		public static bool GreatherThanOrEqual(PgTimeSpan x, PgTimeSpan y)
		{
			return (x >= y);
		}

		public static bool LessThan(PgTimeSpan x, PgTimeSpan y)
		{
			return (x < y);
		}

		public static bool LessThanOrEqual(PgTimeSpan x, PgTimeSpan y)
		{
			return (x <= y);
		}

		public static bool NotEquals(PgTimeSpan x, PgTimeSpan y)
		{
			return (x != y);
		}

		public static PgTimeSpan Parse(string s)
		{
			return new PgTimeSpan(TimeSpan.Parse(s));
		}

		#endregion

		#region Operators

		public static bool operator ==(PgTimeSpan left, PgTimeSpan right)
		{
			bool equals = false;

			if (left.Value == right.Value)
			{
				equals = true;
			}

			return equals;
		}

		public static bool operator !=(PgTimeSpan left, PgTimeSpan right)
		{
			bool notequals = false;

			if (left.Value != right.Value)
			{
				notequals = true;
			}

			return notequals;
		}

		public static bool operator >(PgTimeSpan left, PgTimeSpan right)
		{
			bool greater = false;

			if (left.Value > right.Value)
			{
				greater = true;
			}

			return greater;
		}

		public static bool operator >=(PgTimeSpan left, PgTimeSpan right)
		{
			bool greater = false;

			if (left.Value >= right.Value)
			{
				greater = true;
			}

			return greater;
		}

		public static bool operator <(PgTimeSpan left, PgTimeSpan right)
		{
			bool less = false;

			if (left.Value < right.Value)
			{
				less = true;
			}

			return less;
		}

		public static bool operator <=(PgTimeSpan left, PgTimeSpan right)
		{
			bool less = false;

			if (left.Value <= right.Value)
			{
				less = true;
			}

			return less;
		}

		public static explicit operator TimeSpan(PgTimeSpan x)
		{
			return x.Value;
		}

		public static explicit operator PgTimeSpan(string x)
		{
			return new PgTimeSpan(TimeSpan.Parse(x));
		}

		#endregion

		#region Overriden Methods

		public override string ToString()
		{
			return interval.ToString();
		}

		public override int GetHashCode()
		{
			return interval.GetHashCode();
		}

		public override bool Equals(object obj)
		{
			if (obj is PgTimeSpan)
			{
				return ((PgTimeSpan)obj) == this;
			}
			else
			{
				return false;
			}
		}

		#endregion
	}
}
