/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.NPgClient
{
	internal class PgBackendCodes
	{
		// Backend Message Formats
		public const char AUTHENTICATION			= 'R';
		public const char BACKEND_KEY_DATA			= 'K';
		public const char BIND_COMPLETE				= '2';
		public const char CLOSE_COMPLETE			= '3';
		public const char COMMAND_COMPLETE			= 'C';
		public const char COPY_IN_RESPONSE			= 'G';
		public const char COPY_OUT_RESPONSE			= 'H';
		public const char DATAROW					= 'D';
		public const char EMPTY_QUERY_RESPONSE		= 'I';
		public const char ERROR_RESPONSE			= 'E';
		public const char FUNCTION_CALL_RESPONSE	= 'V';
		public const char NODATA					= 'n';
		public const char NOTICE_RESPONSE			= 'N';
		public const char NOTIFICATION_RESPONSE		= 'A';
		public const char PARAMETER_DESCRIPTION		= 't';
		public const char PARAMETER_STATUS			= 'S';
		public const char PARSE_COMPLETE			= '1';
		public const char PORTAL_SUSPENDED			= 's';
		public const char READY_FOR_QUERY			= 'Z';
		public const char ROW_DESCRIPTION			= 'T';
	}

	internal class PgFrontEndCodes
	{		
		public const char BIND					= 'B';
		public const char CLOSE					= 'C';		
		public const char COPY_FAIL				= 'f';
		public const char DESCRIBE				= 'D';
		public const char EXECUTE				= 'E';		
		public const char FLUSH					= 'H';
		public const char FUNCTION_CALL			= 'F';
		public const char PARSE					= 'P';
		public const char PASSWORD_MESSAGE		= 'p';
		public const char QUERY					= 'Q';
		public const char SYNC					= 'S';
		public const char TERMINATE				= 'X';
	}

	internal class PgErrorCodes
	{		
		public const char SEVERITY				= 'S';
		public const char CODE					= 'C';
		public const char MESSAGE				= 'M';
		public const char DETAIL				= 'D';
		public const char HINT					= 'H';
		public const char POSITION				= 'P';
		public const char WHERE					= 'W';
		public const char FILE					= 'F';
		public const char LINE					= 'L';
		public const char ROUTINE				= 'R';		
		public const char END					= '\0';
	}

	internal class PgCodes
	{
		// Protocol version 3.0
		public const int PROTOCOL_VERSION2_MAYOR	= 2;
		public const int PROTOCOL_VERSION2_MINOR	= 0;
		public const int PROTOCOL_VERSION2			= (PROTOCOL_VERSION2_MAYOR << 16) | PROTOCOL_VERSION2_MINOR;

		// Protocol version 3.0
		public const int PROTOCOL_VERSION3_MAYOR	= 3;
		public const int PROTOCOL_VERSION3_MINOR	= 0;
		public const int PROTOCOL_VERSION3			= (PROTOCOL_VERSION3_MAYOR << 16) | PROTOCOL_VERSION3_MINOR;

		// SSL Request code
		public const int SSL_REQUEST_MOST			= 1234;
		public const int SSL_REQUEST_LEAST			= 5679;
		public const int SSL_REQUEST				= (SSL_REQUEST_MOST << 16) | SSL_REQUEST_LEAST;

		// Cancel request code
		public const int CANCEL_REQUEST_MOST		= 1234;
		public const int CANCEL_REQUEST_LEAST		= 5678;
		public const int CANCEL_REQUEST				= (CANCEL_REQUEST_MOST << 16) | CANCEL_REQUEST_LEAST;

		// Backend & FrontEnd Message Formats
		public const int COPY_DATA					= 'd';
		public const int COPY_DONE					= 'c';		

		// Authentication values
		public const int AUTH_OK					= 0;
		public const int AUTH_KERBEROS_V4			= 1;
		public const int AUTH_KERBEROS_V5			= 2;
		public const int AUTH_CLEARTEXT_PASSWORD	= 3;
		public const int AUTH_CRYPT_PASSWORD		= 4;
		public const int AUTH_MD5_PASSWORD			= 5;
		public const int AUTH_SCM_CREDENTIAL		= 6;
			
		// Max keys for vector data type
		public const int INDEX_MAX_KEYS			= 32;

		//
		public const char NULL_TERMINATOR		= '\0';

		//
		public static readonly DateTime BASE_DATE	= new DateTime(2000, 1, 1);

		// MD5 prefix
		public static string MD5_PREFIX			= "md5";

		// Format codes
		public const int TEXT_FORMAT			= 0;
		public const int BINARY_FORMAT			= 1;

		// Numeric data type
		public const int NUMERIC_SIGN_MASK		= 0xC000;
		public const int NUMERIC_POS            = 0x0000;
		public const int NUMERIC_NEG			= 0x4000;		
		public const int NUMERIC_NAN            = 0xC000;
		public const int NUMERIC_MAX_PRECISION	= 1000;
		public const int NUMERIC_DSCALE_MASK	= 0x3FFF;
		public const int NUMERIC_HDRSZ			= 10;
	}
}
