/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections;
using System.Globalization;

namespace PostgreSql.Data.NPgClient
{
	internal sealed class PgClientErrorCollection : ArrayList
	{
		#region Properties

		public PgClientError this[string errorMessage] 
		{
			get { return (PgClientError)this[IndexOf(errorMessage)]; }
			set { this[IndexOf(errorMessage)] = (PgClientError)value; }
		}

		public new PgClientError this[int errorIndex] 
		{
			get { return (PgClientError)base[errorIndex]; }
			set { base[errorIndex] = (PgClientError)value; }
		}

		#endregion

		#region Methods
	
		public bool Contains(string errorMessage)
		{
			return(-1 != IndexOf(errorMessage));
		}
		
		public int IndexOf(string errorMessage)
		{
			int index = 0;
			foreach(PgClientError item in this)
			{
				if (cultureAwareCompare(item.Message, errorMessage))
				{
					return index;
				}
				index++;
			}
			return -1;
		}

		public void RemoveAt(string errorMessage)
		{
			RemoveAt(IndexOf(errorMessage));
		}

		public PgClientError Add(PgClientError error)
		{
			base.Add(error);

			return error;
		}

		public PgClientError Add(string severity, string message, string code)
		{
			PgClientError error = new PgClientError(severity, code, message);

			return Add(error);
		}

		private bool cultureAwareCompare(string strA, string strB)
		{
			return CultureInfo.CurrentCulture.CompareInfo.Compare(
				strA, 
				strB, 
				CompareOptions.IgnoreKanaType | CompareOptions.IgnoreWidth | 
				CompareOptions.IgnoreCase) == 0 ? true : false;
		}

		#endregion
	}
}
