/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.codehaus.plexus.util.dag.CycleDetectedException;

public class DefaultProjectDependencyGraph
implements ProjectDependencyGraph {
    private ProjectSorter sorter;
    private List<MavenProject> allProjects;
    private Map<MavenProject, Integer> order;
    private Map<String, MavenProject> projects;

    public DefaultProjectDependencyGraph(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(projects));
        this.sorter = new ProjectSorter(projects);
        this.order = new HashMap<MavenProject, Integer>();
        this.projects = new HashMap<String, MavenProject>();
        List sorted = this.sorter.getSortedProjects();
        for (int index = 0; index < sorted.size(); ++index) {
            MavenProject project = (MavenProject)sorted.get(index);
            String id = ProjectSorter.getId((MavenProject)project);
            this.projects.put(id, project);
            this.order.put(project, index);
        }
    }

    public DefaultProjectDependencyGraph(List<MavenProject> allProjects, Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(allProjects));
        this.sorter = new ProjectSorter(projects);
        this.order = new HashMap<MavenProject, Integer>();
        this.projects = new HashMap<String, MavenProject>();
        List sorted = this.sorter.getSortedProjects();
        for (int index = 0; index < sorted.size(); ++index) {
            MavenProject project = (MavenProject)sorted.get(index);
            String id = ProjectSorter.getId((MavenProject)project);
            this.projects.put(id, project);
            this.order.put(project, index);
        }
    }

    public List<MavenProject> getAllProjects() {
        return this.allProjects;
    }

    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId((MavenProject)project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Set<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependents(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getDownstreamProjects(id, projectIds, transitive);
        }
    }

    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId((MavenProject)project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependencies(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getUpstreamProjects(id, projectIds, transitive);
        }
    }

    private List<MavenProject> getSortedProjects(Set<String> projectIds) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(projectIds.size());
        for (String projectId : projectIds) {
            result.add(this.projects.get(projectId));
        }
        result.sort(new MavenProjectComparator());
        return result;
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }

    private class MavenProjectComparator
    implements Comparator<MavenProject> {
        private MavenProjectComparator() {
        }

        @Override
        public int compare(MavenProject o1, MavenProject o2) {
            return (Integer)DefaultProjectDependencyGraph.this.order.get(o1) - (Integer)DefaultProjectDependencyGraph.this.order.get(o2);
        }
    }
}

