/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.logging.smart;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.Map;
import org.apache.maven.shared.utils.logging.LoggerLevelRenderer;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.mvndaemon.mvnd.logging.smart.BuildEventListener;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ProjectBuildLogAppender
extends AppenderBase<ILoggingEvent>
implements AutoCloseable {
    private static final String KEY_PROJECT_ID = "maven.project.id";
    private static final ThreadLocal<String> PROJECT_ID = new InheritableThreadLocal<String>();
    private static final ThreadLocal<String> FORKING_PROJECT_ID = new InheritableThreadLocal<String>();
    private static final String pattern = "[%level] %msg%n";
    private final PatternLayout layout;
    private final BuildEventListener buildEventListener;

    public static String getProjectId() {
        return PROJECT_ID.get();
    }

    public static void setProjectId(String projectId) {
        String forkingProjectId = FORKING_PROJECT_ID.get();
        if (forkingProjectId != null) {
            projectId = projectId != null ? forkingProjectId + "/" + projectId : forkingProjectId;
        }
        if (projectId != null) {
            PROJECT_ID.set(projectId);
            MDC.put((String)KEY_PROJECT_ID, (String)projectId);
        } else {
            PROJECT_ID.remove();
            MDC.remove((String)KEY_PROJECT_ID);
        }
    }

    public static void setForkingProjectId(String forkingProjectId) {
        if (forkingProjectId != null) {
            FORKING_PROJECT_ID.set(forkingProjectId);
        } else {
            FORKING_PROJECT_ID.remove();
        }
    }

    public static void updateMdc() {
        String id = ProjectBuildLogAppender.getProjectId();
        if (id != null) {
            MDC.put((String)KEY_PROJECT_ID, (String)id);
        } else {
            MDC.remove((String)KEY_PROJECT_ID);
        }
    }

    public ProjectBuildLogAppender(BuildEventListener buildEventListener) {
        this.buildEventListener = buildEventListener;
        this.name = ProjectBuildLogAppender.class.getName();
        this.context = (Context)LoggerFactory.getILoggerFactory();
        PatternLayout l = new PatternLayout();
        l.setContext(this.context);
        l.setPattern(pattern);
        Map instanceConverterMap = l.getInstanceConverterMap();
        String levelConverterClassName = LevelConverter.class.getName();
        instanceConverterMap.put("level", levelConverterClassName);
        instanceConverterMap.put("le", levelConverterClassName);
        instanceConverterMap.put("p", levelConverterClassName);
        this.layout = l;
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.addAppender((Appender)this);
        this.start();
    }

    public void start() {
        this.layout.start();
        super.start();
    }

    protected void append(ILoggingEvent event) {
        String projectId = (String)event.getMDCPropertyMap().get(KEY_PROJECT_ID);
        this.buildEventListener.projectLogMessage(projectId, this.layout.doLayout(event));
    }

    @Override
    public void close() {
        this.stop();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.detachAppender((Appender)this);
    }

    public void stop() {
        this.layout.stop();
        super.stop();
    }

    public static class LevelConverter
    extends ClassicConverter {
        public String convert(ILoggingEvent event) {
            LoggerLevelRenderer llr = MessageUtils.level();
            Level level = event.getLevel();
            switch (level.toInt()) {
                case 40000: {
                    return llr.error(level.toString());
                }
                case 30000: {
                    return llr.warning(level.toString());
                }
                case 20000: {
                    return llr.info(level.toString());
                }
            }
            return llr.debug(level.toString());
        }
    }
}

