/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.console.interactive;

import java.io.IOException;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.CompletionHandler;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private boolean eagerNewlines = true;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            jline.console.completer.CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            jline.console.completer.CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.println();
        }
        jline.console.completer.CandidateListCompletionHandler.printCandidates(reader, candidates);
        reader.drawLine();
        return true;
    }

    private String getUnambiguousCompletions(List<?> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String[] strings = candidates.toArray(new String[0]);
        String first = strings[0];
        StringBuilder candidate = new StringBuilder();
        int count = first.length();
        for (int i = 0; i < count && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private boolean startsWith(String starts, String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].startsWith(starts)) continue;
            return false;
        }
        return true;
    }
}

