/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.util.Path;

public class TaskInAnotherBuild
extends TaskNode
implements SelfExecutingNode {
    private IncludedBuildTaskResource.State taskState = IncludedBuildTaskResource.State.Waiting;
    private final Path taskIdentityPath;
    private final String taskPath;
    private final BuildIdentifier targetBuild;
    private final IncludedBuildTaskResource target;

    public static TaskInAnotherBuild of(TaskInternal task, BuildTreeWorkGraphController taskGraph) {
        BuildIdentifier targetBuild = TaskInAnotherBuild.buildIdentifierOf(task);
        TaskIdentifier.TaskBasedTaskIdentifier taskIdentifier = TaskIdentifier.of(targetBuild, task);
        IncludedBuildTaskResource taskResource = taskGraph.locateTask(taskIdentifier);
        return new TaskInAnotherBuild(task.getIdentityPath(), task.getPath(), targetBuild, taskResource);
    }

    public static TaskInAnotherBuild of(String taskPath, BuildIdentifier targetBuild, BuildTreeWorkGraphController taskGraph) {
        TaskIdentifier taskIdentifier = TaskIdentifier.of(targetBuild, taskPath);
        IncludedBuildTaskResource taskResource = taskGraph.locateTask(taskIdentifier);
        Path taskIdentityPath = Path.path((String)targetBuild.getName()).append(Path.path((String)taskPath));
        return new TaskInAnotherBuild(taskIdentityPath, taskPath, targetBuild, taskResource);
    }

    protected TaskInAnotherBuild(Path taskIdentityPath, String taskPath, BuildIdentifier targetBuild, IncludedBuildTaskResource target) {
        this.taskIdentityPath = taskIdentityPath;
        this.taskPath = taskPath;
        this.targetBuild = targetBuild;
        this.target = target;
    }

    public BuildIdentifier getTargetBuild() {
        return this.targetBuild;
    }

    public String getTaskPath() {
        return this.taskPath;
    }

    @Override
    public TaskInternal getTask() {
        return this.target.getTask();
    }

    @Override
    public Set<Node> getLifecycleSuccessors() {
        return Collections.emptySet();
    }

    @Override
    public void setLifecycleSuccessors(Set<Node> successors) {
        if (!successors.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void prepareForExecution(Action<Node> monitor) {
        this.target.queueForExecution();
        this.target.onComplete(() -> monitor.execute((Object)this));
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return null;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    @Override
    public Throwable getNodeFailure() {
        return null;
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
    }

    @Override
    public Node.DependenciesState doCheckDependenciesComplete() {
        Node.DependenciesState dependenciesState = super.doCheckDependenciesComplete();
        if (dependenciesState != Node.DependenciesState.COMPLETE_AND_SUCCESSFUL) {
            return dependenciesState;
        }
        if (!this.taskState.isComplete()) {
            this.taskState = this.target.getTaskState();
        }
        switch (this.taskState) {
            case Waiting: {
                return Node.DependenciesState.NOT_COMPLETE;
            }
            case Success: {
                return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
            }
            case Failed: {
                return Node.DependenciesState.COMPLETE_AND_NOT_SUCCESSFUL;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        TaskInAnotherBuild taskNode = (TaskInAnotherBuild)other;
        return this.taskIdentityPath.compareTo(taskNode.taskIdentityPath);
    }

    @Override
    public String toString() {
        return "other build task " + this.taskIdentityPath;
    }

    @Override
    protected void nodeSpecificHealthDiagnostics(StringBuilder builder) {
        builder.append(", taskState=").append((Object)this.taskState).append(", ").append(this.target.healthDiagnostics());
    }

    @Override
    public void execute(NodeExecutionContext context) {
    }

    private static BuildIdentifier buildIdentifierOf(TaskInternal task) {
        return ((ProjectInternal)task.getProject()).getOwner().getOwner().getBuildIdentifier();
    }
}

