/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SingleFileTreeElementMatcher;
import org.gradle.execution.plan.ValuedVfsHierarchy;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.file.Stat;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.VfsRelativePath;

public class ExecutionNodeAccessHierarchy {
    private volatile ValuedVfsHierarchy<NodeAccess> root;
    private final SingleFileTreeElementMatcher matcher;

    public ExecutionNodeAccessHierarchy(CaseSensitivity caseSensitivity, Stat stat) {
        this.root = ValuedVfsHierarchy.emptyHierarchy(caseSensitivity);
        this.matcher = new SingleFileTreeElementMatcher(stat);
    }

    public ImmutableSet<Node> getNodesAccessing(String location) {
        return this.visitValues(location, new AbstractNodeAccessVisitor(){

            @Override
            public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
                values.forEach(this::addNode);
            }
        });
    }

    public ImmutableSet<Node> getNodesAccessing(final String location, final Spec<FileTreeElement> filter) {
        return this.visitValues(location, new AbstractNodeAccessVisitor(){

            @Override
            public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
                String relativePathFromLocation = relativePathSupplier.get();
                if (ExecutionNodeAccessHierarchy.this.matcher.elementWithRelativePathMatches((Spec<FileTreeElement>)filter, new File(location, relativePathFromLocation), relativePathFromLocation)) {
                    values.forEach(this::addNode);
                }
            }
        });
    }

    public synchronized void recordNodeAccessingLocations(Node node, Iterable<String> accessedLocations) {
        for (String location : accessedLocations) {
            VfsRelativePath relativePath = VfsRelativePath.of((String)location);
            this.root = this.root.recordValue(relativePath, new DefaultNodeAccess(node));
        }
    }

    public synchronized void recordNodeAccessingFileTree(Node node, String fileTreeRoot, Spec<FileTreeElement> filter) {
        VfsRelativePath relativePath = VfsRelativePath.of((String)fileTreeRoot);
        this.root = this.root.recordValue(relativePath, new FilteredNodeAccess(node, filter));
    }

    public synchronized void clear() {
        this.root = this.root.empty();
    }

    private ImmutableSet<Node> visitValues(String location, AbstractNodeAccessVisitor visitor) {
        this.root.visitValues(location, visitor);
        return visitor.getResult();
    }

    private class FilteredNodeAccess
    implements NodeAccess {
        private final Node node;
        private final Spec<FileTreeElement> spec;

        public FilteredNodeAccess(Node node, Spec<FileTreeElement> spec) {
            this.node = node;
            this.spec = spec;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return ExecutionNodeAccessHierarchy.this.matcher.elementWithRelativePathMatches(this.spec, new File(childPath.getAbsolutePath()), childPath.getAsString());
        }
    }

    private static class DefaultNodeAccess
    implements NodeAccess {
        private final Node node;

        public DefaultNodeAccess(Node node) {
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return true;
        }
    }

    private static interface NodeAccess {
        public Node getNode();

        public boolean accessesChild(VfsRelativePath var1);
    }

    private static abstract class AbstractNodeAccessVisitor
    implements ValuedVfsHierarchy.ValueVisitor<NodeAccess> {
        private final ImmutableSet.Builder<Node> builder = ImmutableSet.builder();

        private AbstractNodeAccessVisitor() {
        }

        public void addNode(NodeAccess value) {
            this.builder.add((Object)value.getNode());
        }

        @Override
        public void visitExact(NodeAccess value) {
            this.addNode(value);
        }

        @Override
        public void visitAncestor(NodeAccess value, VfsRelativePath pathToVisitedLocation) {
            if (value.accessesChild(pathToVisitedLocation)) {
                this.addNode(value);
            }
        }

        public ImmutableSet<Node> getResult() {
            return this.builder.build();
        }
    }
}

