/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.configurations.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.attributes.DefaultCompatibilityRuleChain;
import org.gradle.api.internal.attributes.DefaultDisambiguationRuleChain;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ConfigurationReportModel;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportArtifact;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportAttribute;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportCapability;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportConfiguration;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportSecondaryVariant;

public final class ConfigurationReportModelFactory {
    private final FileResolver fileResolver;

    public ConfigurationReportModelFactory(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public ConfigurationReportModel buildForProject(Project project) {
        ConfigurationRuleScanner scanner = new ConfigurationRuleScanner(project);
        List<ReportAttribute> attributesWithCompatibilityRules = scanner.getAttributesWithCompatibilityRules();
        List<ReportAttribute> attributesWithDisambiguationRules = scanner.getAttributesWithDisambiguationRules();
        HashMap convertedConfigurations = new HashMap(project.getConfigurations().size());
        project.getConfigurations().stream().map(ConfigurationInternal.class::cast).forEach(configuration -> this.getOrConvert((ConfigurationInternal)configuration, project, convertedConfigurations));
        return new ConfigurationReportModel(project.getName(), convertedConfigurations.values().stream().sorted(Comparator.comparing(ReportConfiguration::getName)).collect(Collectors.toList()), attributesWithCompatibilityRules, attributesWithDisambiguationRules);
    }

    private ReportConfiguration getOrConvert(ConfigurationInternal configuration, Project project, Map<String, ReportConfiguration> convertedConfigurations) {
        return ConfigurationReportModelFactory.computeIfAbsentExternal(convertedConfigurations, configuration.getName(), name -> {
            ArrayList<ReportConfiguration> extendedConfigurations = new ArrayList<ReportConfiguration>(configuration.getExtendsFrom().size());
            configuration.getExtendsFrom().stream().map(ConfigurationInternal.class::cast).forEach(c -> extendedConfigurations.add(this.getOrConvert((ConfigurationInternal)c, project, convertedConfigurations)));
            return this.convertConfiguration(configuration, project, this.fileResolver, extendedConfigurations);
        });
    }

    private ReportConfiguration convertConfiguration(ConfigurationInternal configuration, Project project, FileResolver fileResolver, List<ReportConfiguration> extendedConfigurations) {
        configuration.preventFromFurtherMutation();
        List<ReportAttribute> attributes = configuration.getAttributes().keySet().stream().map(a -> this.convertAttributeInContainer((Attribute<?>)a, (AttributeContainer)configuration.getAttributes())).sorted(Comparator.comparing(ReportAttribute::getName)).collect(Collectors.toList());
        List explicitCapabilities = configuration.getOutgoing().getCapabilities().stream().map(this::convertCapability).sorted(Comparator.comparing(ReportCapability::toGAV)).collect(Collectors.toList());
        List<ReportCapability> capabilities = explicitCapabilities.isEmpty() ? Collections.singletonList(this.convertDefaultCapability(project)) : explicitCapabilities;
        List<ReportArtifact> artifacts = configuration.getAllArtifacts().stream().map(a -> this.convertPublishArtifact((PublishArtifact)a, fileResolver)).sorted(Comparator.comparing(ReportArtifact::getDisplayName)).collect(Collectors.toList());
        List<ReportSecondaryVariant> variants = configuration.getOutgoing().getVariants().stream().map(v -> this.convertConfigurationVariant((ConfigurationVariant)v, fileResolver)).sorted(Comparator.comparing(ReportSecondaryVariant::getName)).collect(Collectors.toList());
        ReportConfiguration.Type type = configuration.isCanBeConsumed() && configuration.isCanBeResolved() ? ReportConfiguration.Type.LEGACY : (configuration.isCanBeResolved() ? ReportConfiguration.Type.RESOLVABLE : (configuration.isCanBeConsumed() ? ReportConfiguration.Type.CONSUMABLE : null));
        return new ReportConfiguration(configuration.getName(), configuration.getDescription(), type, attributes, capabilities, artifacts, variants, extendedConfigurations);
    }

    private ReportArtifact convertPublishArtifact(PublishArtifact publishArtifact, FileResolver fileResolver) {
        return new ReportArtifact(publishArtifact.getName(), fileResolver.resolveForDisplay((Object)publishArtifact.getFile()), publishArtifact.getClassifier(), publishArtifact.getType());
    }

    private ReportSecondaryVariant convertConfigurationVariant(ConfigurationVariant variant, FileResolver fileResolver) {
        List<ReportAttribute> attributes = Collections.unmodifiableList(variant.getAttributes().keySet().stream().map(a -> this.convertAttributeInContainer((Attribute<?>)a, variant.getAttributes())).sorted(Comparator.comparing(ReportAttribute::getName)).collect(Collectors.toList()));
        List<ReportArtifact> artifacts = Collections.unmodifiableList(variant.getArtifacts().stream().map(publishArtifact -> this.convertPublishArtifact((PublishArtifact)publishArtifact, fileResolver)).sorted(Comparator.comparing(ReportArtifact::getName)).collect(Collectors.toList()));
        return new ReportSecondaryVariant(variant.getName(), variant.getDescription().orElse(null), attributes, artifacts);
    }

    private ReportAttribute convertAttributeInContainer(Attribute<?> attribute, AttributeContainer container) {
        Attribute<?> key = attribute;
        Object value = container.getAttribute(key);
        return new ReportAttribute(key, value);
    }

    private ReportAttribute convertUncontainedAttribute(Attribute<?> attribute) {
        Attribute<?> key = attribute;
        return new ReportAttribute(key, null);
    }

    private ReportCapability convertCapability(Capability capability) {
        return new ReportCapability(capability.getGroup(), capability.getName(), capability.getVersion(), false);
    }

    private ReportCapability convertDefaultCapability(Project project) {
        return new ReportCapability(Objects.toString(project.getGroup()), project.getName(), Objects.toString(project.getVersion()), true);
    }

    private static <K, V> V computeIfAbsentExternal(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        V v = mappingFunction.apply(key);
        map.put(key, v);
        return v;
    }

    private final class ConfigurationRuleScanner {
        private final AttributesSchema attributesSchema;

        public ConfigurationRuleScanner(Project project) {
            this.attributesSchema = project.getDependencies().getAttributesSchema();
        }

        public List<ReportAttribute> getAttributesWithCompatibilityRules() {
            return this.attributesSchema.getAttributes().stream().filter(this::hasCompatibilityRules).map(x$0 -> ConfigurationReportModelFactory.this.convertUncontainedAttribute(x$0)).sorted(Comparator.comparing(ReportAttribute::getName)).collect(Collectors.toList());
        }

        public List<ReportAttribute> getAttributesWithDisambiguationRules() {
            return this.attributesSchema.getAttributes().stream().filter(this::hasDisambiguationRules).map(x$0 -> ConfigurationReportModelFactory.this.convertUncontainedAttribute(x$0)).sorted(Comparator.comparing(ReportAttribute::getName)).collect(Collectors.toList());
        }

        private boolean hasCompatibilityRules(Attribute<?> attribute) {
            AttributeMatchingStrategy matchingStrategy = this.attributesSchema.getMatchingStrategy(attribute);
            DefaultCompatibilityRuleChain ruleChain = (DefaultCompatibilityRuleChain)matchingStrategy.getCompatibilityRules();
            return ruleChain.doesSomething();
        }

        private boolean hasDisambiguationRules(Attribute<?> attribute) {
            AttributeMatchingStrategy matchingStrategy = this.attributesSchema.getMatchingStrategy(attribute);
            DefaultDisambiguationRuleChain ruleChain = (DefaultDisambiguationRuleChain)matchingStrategy.getDisambiguationRules();
            return ruleChain.doesSomething();
        }
    }
}

