/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

@UntrackedTask(because="Produces only non-cacheable console output")
public class BuildEnvironmentReportTask
extends DefaultTask {
    public static final String TASK_NAME = "buildEnvironment";
    private DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        this.reportGenerator().generateReport(Collections.singleton(this.getProject()), project -> {
            Configuration configuration = project.getBuildscript().getConfigurations().getByName("classpath");
            this.renderer.startConfiguration(configuration);
            this.renderer.render(configuration);
            this.renderer.completeConfiguration(configuration);
        });
    }

    private ReportGenerator reportGenerator() {
        return new ReportGenerator(this.renderer, this.getClientMetaData(), null, this.getTextOutputFactory());
    }

    @VisibleForTesting
    protected void setRenderer(DependencyReportRenderer dependencyReportRenderer) {
        this.renderer = dependencyReportRenderer;
    }
}

