/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public final class CharsetToolkit {
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final Charset UTF_16_CHARSET = StandardCharsets.UTF_16;
    public static final Charset UTF_16LE_CHARSET = StandardCharsets.UTF_16LE;
    public static final Charset UTF_16BE_CHARSET = StandardCharsets.UTF_16BE;
    public static final Charset UTF_32BE_CHARSET = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE_CHARSET = Charset.forName("UTF-32LE");
    public static final Charset US_ASCII_CHARSET = StandardCharsets.US_ASCII;
    public static final Charset ISO_8859_1_CHARSET = StandardCharsets.ISO_8859_1;
    public static final Charset WIN_1251_CHARSET = Charset.forName("windows-1251");
    private final byte[] buffer;
    @NotNull
    private final Charset defaultCharset;
    private boolean enforce8Bit;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    private static final Map<Charset, byte[]> CHARSET_TO_MANDATORY_BOM = new HashMap<Charset, byte[]>(4);

    public CharsetToolkit(byte @NotNull [] buffer, @NotNull Charset defaultCharset) {
        if (defaultCharset == null) {
            CharsetToolkit.$$$reportNull$$$0(1);
        }
        if (buffer == null) {
            CharsetToolkit.$$$reportNull$$$0(2);
        }
        this.buffer = buffer;
        this.defaultCharset = defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            CharsetToolkit.$$$reportNull$$$0(3);
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(4);
        boolean mustReset = true;
        int ret = stream.read();
        if (ret == -1) {
            InputStream inputStream = stream;
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) {
                CharsetToolkit.$$$reportNull$$$0(4);
            }
            return inputStream2;
        }
        byte b0 = (byte)ret;
        if (b0 != -17 && b0 != -1 && b0 != -2 && b0 != 0) {
            InputStream inputStream = stream;
            InputStream inputStream3 = inputStream;
            if (inputStream3 == null) {
                CharsetToolkit.$$$reportNull$$$0(5);
            }
            return inputStream3;
        }
        ret = stream.read();
        if (ret == -1) {
            InputStream inputStream = stream;
            InputStream inputStream4 = inputStream;
            if (inputStream4 == null) {
                CharsetToolkit.$$$reportNull$$$0(6);
            }
            return inputStream4;
        }
        byte b1 = (byte)ret;
        if (b0 == -1 && b1 == -2) {
            stream.mark(2);
            ret = stream.read();
            if (ret == -1) {
                InputStream inputStream = stream;
                InputStream inputStream5 = inputStream;
                if (inputStream5 == null) {
                    CharsetToolkit.$$$reportNull$$$0(7);
                }
                return inputStream5;
            }
            byte b2 = (byte)ret;
            if (b2 != 0) {
                InputStream inputStream = stream;
                InputStream inputStream6 = inputStream;
                if (inputStream6 == null) {
                    CharsetToolkit.$$$reportNull$$$0(8);
                }
                return inputStream6;
            }
            ret = stream.read();
            if (ret == -1) {
                InputStream inputStream = stream;
                InputStream inputStream7 = inputStream;
                if (inputStream7 == null) {
                    CharsetToolkit.$$$reportNull$$$0(9);
                }
                return inputStream7;
            }
            byte b3 = (byte)ret;
            if (b3 != 0) {
                InputStream inputStream = stream;
                InputStream inputStream8 = inputStream;
                if (inputStream8 == null) {
                    CharsetToolkit.$$$reportNull$$$0(10);
                }
                return inputStream8;
            }
            mustReset = false;
            InputStream inputStream = stream;
            InputStream inputStream9 = inputStream;
            if (inputStream9 == null) {
                CharsetToolkit.$$$reportNull$$$0(11);
            }
            return inputStream9;
        }
        if (b0 == -2 && b1 == -1) {
            mustReset = false;
            InputStream b2 = stream;
            InputStream inputStream = b2;
            if (inputStream == null) {
                CharsetToolkit.$$$reportNull$$$0(12);
            }
            return inputStream;
        }
        if (b0 == -17 && b1 == -69) {
            ret = stream.read();
            if (ret == -1) {
                InputStream b2 = stream;
                InputStream inputStream = b2;
                if (inputStream == null) {
                    CharsetToolkit.$$$reportNull$$$0(13);
                }
                return inputStream;
            }
            byte b2 = (byte)ret;
            if (b2 == -65) {
                mustReset = false;
                InputStream b3 = stream;
                InputStream inputStream = b3;
                if (inputStream == null) {
                    CharsetToolkit.$$$reportNull$$$0(14);
                }
                return inputStream;
            }
            InputStream b3 = stream;
            InputStream inputStream = b3;
            if (inputStream == null) {
                CharsetToolkit.$$$reportNull$$$0(15);
            }
            return inputStream;
        }
        if (b0 == 0 && b1 == 0) {
            ret = stream.read();
            if (ret == -1) {
                InputStream b2 = stream;
                InputStream inputStream = b2;
                if (inputStream == null) {
                    CharsetToolkit.$$$reportNull$$$0(16);
                }
                return inputStream;
            }
            byte b2 = (byte)ret;
            if (b2 != -2) {
                InputStream b3 = stream;
                InputStream inputStream = b3;
                if (inputStream == null) {
                    CharsetToolkit.$$$reportNull$$$0(17);
                }
                return inputStream;
            }
            ret = stream.read();
            if (ret == -1) {
                InputStream b3 = stream;
                InputStream inputStream = b3;
                if (inputStream == null) {
                    CharsetToolkit.$$$reportNull$$$0(18);
                }
                return inputStream;
            }
            byte b3 = (byte)ret;
            if (b3 != -1) {
                InputStream inputStream = stream;
                InputStream inputStream10 = inputStream;
                if (inputStream10 == null) {
                    CharsetToolkit.$$$reportNull$$$0(19);
                }
                return inputStream10;
            }
            mustReset = false;
            InputStream inputStream = stream;
            InputStream inputStream11 = inputStream;
            if (inputStream11 == null) {
                CharsetToolkit.$$$reportNull$$$0(20);
            }
            return inputStream11;
        }
        InputStream inputStream = stream;
        InputStream inputStream12 = inputStream;
        if (inputStream12 == null) {
            CharsetToolkit.$$$reportNull$$$0(21);
        }
        return inputStream12;
        finally {
            if (mustReset) {
                stream.reset();
            }
        }
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    @NotNull
    public GuessedEncoding guessFromContent(int startOffset, int endOffset) {
        boolean highOrderBit = false;
        boolean validU8Char = true;
        boolean hasBinary = false;
        int end = Math.min(this.buffer.length, endOffset);
        for (int i = startOffset; i < end; ++i) {
            byte b5;
            byte b0 = this.buffer[i];
            byte b1 = i + 1 >= end ? (byte)0 : this.buffer[i + 1];
            byte b2 = i + 2 >= end ? (byte)0 : this.buffer[i + 2];
            byte b3 = i + 3 >= end ? (byte)0 : this.buffer[i + 3];
            byte b4 = i + 4 >= end ? (byte)0 : this.buffer[i + 4];
            byte by = b5 = i + 5 >= end ? (byte)0 : this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            } else if (b0 < 9) {
                hasBinary = true;
                break;
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit && !hasBinary) {
            GuessedEncoding guessedEncoding = GuessedEncoding.SEVEN_BIT;
            if (guessedEncoding == null) {
                CharsetToolkit.$$$reportNull$$$0(32);
            }
            return guessedEncoding;
        }
        if (!validU8Char) {
            GuessedEncoding guessedEncoding = GuessedEncoding.INVALID_UTF8;
            if (guessedEncoding == null) {
                CharsetToolkit.$$$reportNull$$$0(33);
            }
            return guessedEncoding;
        }
        if (hasBinary) {
            GuessedEncoding guessedEncoding = GuessedEncoding.BINARY;
            if (guessedEncoding == null) {
                CharsetToolkit.$$$reportNull$$$0(34);
            }
            return guessedEncoding;
        }
        GuessedEncoding guessedEncoding = GuessedEncoding.VALID_UTF8;
        if (guessedEncoding == null) {
            CharsetToolkit.$$$reportNull$$$0(35);
        }
        return guessedEncoding;
    }

    @Nullable
    public Charset guessFromBOM() {
        return CharsetToolkit.guessFromBOM(this.buffer);
    }

    @Nullable
    public static Charset guessFromBOM(byte @NotNull [] buffer) {
        if (buffer == null) {
            CharsetToolkit.$$$reportNull$$$0(36);
        }
        if (CharsetToolkit.hasUTF8Bom(buffer)) {
            return StandardCharsets.UTF_8;
        }
        if (CharsetToolkit.hasUTF32BEBom(buffer)) {
            return UTF_32BE_CHARSET;
        }
        if (CharsetToolkit.hasUTF32LEBom(buffer)) {
            return UTF_32LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(buffer)) {
            return UTF_16LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16BEBom(buffer)) {
            return UTF_16BE_CHARSET;
        }
        return null;
    }

    private static boolean isContinuationChar(byte b) {
        return b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    @NotNull
    public static Charset getDefaultSystemCharset() {
        Charset charset = Charset.defaultCharset();
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(39);
        }
        return charset;
    }

    @NotNull
    public static Charset getPlatformCharset() {
        String name = System.getProperty("sun.jnu.encoding");
        Charset value2 = CharsetToolkit.forName(name);
        Charset charset = value2 == null ? CharsetToolkit.getDefaultSystemCharset() : value2;
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(40);
        }
        return charset;
    }

    public static boolean hasUTF8Bom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(41);
        }
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(42);
        }
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(43);
        }
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    public static boolean hasUTF32BEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(44);
        }
        return ArrayUtil.startsWith(bom, UTF32BE_BOM);
    }

    public static boolean hasUTF32LEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(45);
        }
        return ArrayUtil.startsWith(bom, UTF32LE_BOM);
    }

    public static byte @Nullable [] getMandatoryBom(@NotNull Charset charset) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(51);
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, byte @NotNull [] bom) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(53);
        }
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(54);
        }
        return charset.equals(StandardCharsets.UTF_8) && Arrays.equals(bom, UTF8_BOM) || Arrays.equals(CharsetToolkit.getMandatoryBom(charset), bom);
    }

    @Nullable
    public static Charset forName(@Nullable String name) {
        Charset charset = null;
        if (name != null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException2) {
                // empty catch block
            }
        }
        return charset;
    }

    static {
        CHARSET_TO_MANDATORY_BOM.put(UTF_16LE_CHARSET, UTF16LE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_16BE_CHARSET, UTF16BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32BE_CHARSET, UTF32BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32LE_CHARSET, UTF32LE_BOM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 46: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 23: 
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/CharsetToolkit";
                break;
            }
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 26: 
            case 29: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bom";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/CharsetToolkit";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamSkippingBOM";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeString";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFromContent";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemCharset";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformCharset";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableCharsets";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtf8Bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamSkippingBOM";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 46: 
            case 48: {
                break;
            }
            case 23: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "guessEncoding";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "decodeString";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryDecodeString";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "guessFromBOM";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF8Bom";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF16LEBom";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF16BEBom";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF32BEBom";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF32LEBom";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getUtf8Bytes";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getBOMLength";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getMandatoryBom";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleBom";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "canHaveBom";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8,
        BINARY;

    }
}

