/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.junit.internal.runners.TestIntrospector;
import org.junit.internal.runners.TestMethodRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClassMethodsRunner
extends Runner
implements Filterable,
Sortable {
    private final List<Method> fTestMethods;
    private final Class<?> fTestClass;

    public TestClassMethodsRunner(Class<?> klass) {
        this.fTestClass = klass;
        this.fTestMethods = new TestIntrospector(this.getTestClass()).getTestMethods(Test.class);
    }

    @Override
    public void run(RunNotifier notifier) {
        if (this.fTestMethods.isEmpty()) {
            this.testAborted(notifier, this.getDescription());
        }
        for (Method method : this.fTestMethods) {
            this.invokeTestMethod(method, notifier);
        }
    }

    private void testAborted(RunNotifier notifier, Description description2) {
        notifier.fireTestStarted(description2);
        notifier.fireTestFailure(new Failure(description2, new Exception("No runnable methods")));
        notifier.fireTestFinished(description2);
    }

    @Override
    public Description getDescription() {
        Description spec = Description.createSuiteDescription(this.getName());
        List<Method> testMethods = this.fTestMethods;
        for (Method method : testMethods) {
            spec.addChild(this.methodDescription(method));
        }
        return spec;
    }

    protected String getName() {
        return this.getTestClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        Object test;
        try {
            test = this.createTest();
        }
        catch (Exception e) {
            this.testAborted(notifier, this.methodDescription(method));
            return;
        }
        this.createMethodRunner(test, method, notifier).run();
    }

    protected TestMethodRunner createMethodRunner(Object test, Method method, RunNotifier notifier) {
        return new TestMethodRunner(test, method, notifier, this.methodDescription(method));
    }

    protected String testName(Method method) {
        return method.getName();
    }

    protected Description methodDescription(Method method) {
        return Description.createTestDescription(this.getTestClass(), this.testName(method));
    }

    @Override
    public void filter(Filter filter2) throws NoTestsRemainException {
        Iterator<Method> iter = this.fTestMethods.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            if (filter2.shouldRun(this.methodDescription(method))) continue;
            iter.remove();
        }
        if (this.fTestMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    @Override
    public void sort(final Sorter sorter) {
        Collections.sort(this.fTestMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return sorter.compare(TestClassMethodsRunner.this.methodDescription(o1), TestClassMethodsRunner.this.methodDescription(o2));
            }
        });
    }

    protected Class<?> getTestClass() {
        return this.fTestClass;
    }
}

