/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.BooleanAttribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class Attributes
implements Cloneable,
Iterable<Attribute> {
    private static final String[] Empty = new String[0];
    private int size = 0;
    String[] keys = Empty;
    String[] vals = Empty;

    private void checkCapacity(int minNewSize) {
        int newSize;
        Validate.isTrue(minNewSize >= this.size);
        int curSize = this.keys.length;
        if (curSize >= minNewSize) {
            return;
        }
        int n = newSize = curSize >= 4 ? this.size * 2 : 4;
        if (minNewSize > newSize) {
            newSize = minNewSize;
        }
        this.keys = Attributes.copyOf(this.keys, newSize);
        this.vals = Attributes.copyOf(this.vals, newSize);
    }

    private static String[] copyOf(String[] orig, int size) {
        String[] copy2 = new String[size];
        System.arraycopy(orig, 0, copy2, 0, Math.min(orig.length, size));
        return copy2;
    }

    int indexOfKey(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(String val) {
        return val == null ? "" : val;
    }

    public String get(String key) {
        int i = this.indexOfKey(key);
        return i == -1 ? "" : Attributes.checkNotNull(this.vals[i]);
    }

    public String getIgnoreCase(String key) {
        int i = this.indexOfKeyIgnoreCase(key);
        return i == -1 ? "" : Attributes.checkNotNull(this.vals[i]);
    }

    private void add(String key, String value2) {
        this.checkCapacity(this.size + 1);
        this.keys[this.size] = key;
        this.vals[this.size] = value2;
        ++this.size;
    }

    public Attributes put(String key, String value2) {
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[i] = value2;
        } else {
            this.add(key, value2);
        }
        return this;
    }

    void putIgnoreCase(String key, String value2) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.vals[i] = value2;
            if (!this.keys[i].equals(key)) {
                this.keys[i] = key;
            }
        } else {
            this.add(key, value2);
        }
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        attribute.parent = this;
        return this;
    }

    private void remove(int index2) {
        Validate.isFalse(index2 >= this.size);
        int shifted = this.size - index2 - 1;
        if (shifted > 0) {
            System.arraycopy(this.keys, index2 + 1, this.keys, index2, shifted);
            System.arraycopy(this.vals, index2 + 1, this.vals, index2, shifted);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    public boolean hasKey(String key) {
        return this.indexOfKey(key) != -1;
    }

    public boolean hasKeyIgnoreCase(String key) {
        return this.indexOfKeyIgnoreCase(key) != -1;
    }

    public int size() {
        return this.size;
    }

    public void addAll(Attributes incoming) {
        if (incoming.size() == 0) {
            return;
        }
        this.checkCapacity(this.size + incoming.size);
        for (Attribute attr : incoming) {
            this.put(attr);
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Attributes.this.size;
            }

            @Override
            public Attribute next() {
                Attribute attr = new Attribute(Attributes.this.keys[this.i], Attributes.this.vals[this.i], Attributes.this);
                ++this.i;
                return attr;
            }

            @Override
            public void remove() {
                Attributes.this.remove(--this.i);
            }
        };
    }

    public List<Attribute> asList() {
        ArrayList<BooleanAttribute> list2 = new ArrayList<BooleanAttribute>(this.size);
        for (int i = 0; i < this.size; ++i) {
            Attribute attr = this.vals[i] == null ? new BooleanAttribute(this.keys[i]) : new Attribute(this.keys[i], this.vals[i], this);
            list2.add((BooleanAttribute)attr);
        }
        return Collections.unmodifiableList(list2);
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document("").outputSettings());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return StringUtil.releaseBuilder(sb);
    }

    final void html(Appendable accum, Document.OutputSettings out) throws IOException {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            String key = this.keys[i];
            String val = this.vals[i];
            accum.append(' ').append(key);
            if (Attribute.shouldCollapseAttribute(key, val, out)) continue;
            accum.append("=\"");
            Entities.escape(accum, val == null ? "" : val, out, true, false, false);
            accum.append('\"');
        }
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        if (this.size != that.size) {
            return false;
        }
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        return Arrays.equals(this.vals, that.vals);
    }

    public int hashCode() {
        int result2 = this.size;
        result2 = 31 * result2 + Arrays.hashCode(this.keys);
        result2 = 31 * result2 + Arrays.hashCode(this.vals);
        return result2;
    }

    public Attributes clone() {
        Attributes clone;
        try {
            clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.size = this.size;
        this.keys = Attributes.copyOf(this.keys, this.size);
        this.vals = Attributes.copyOf(this.vals, this.size);
        return clone;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = Normalizer.lowerCase(this.keys[i]);
        }
    }
}

