/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.TypeOfChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/TypeOfChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isTypeOf", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend"})
public final class TypeOfChecker
implements CallChecker {
    @NotNull
    public static final TypeOfChecker INSTANCE = new TypeOfChecker();

    private TypeOfChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "resolvedCall.resultingDescriptor");
        if (!this.isTypeOf((CallableDescriptor)obj)) {
            return;
        }
        Map<TypeParameterDescriptor, KotlinType> object2 = resolvedCall2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(object2, "resolvedCall.typeArguments");
        for (Map.Entry entry : object2.entrySet()) {
            KotlinType argument2 = (KotlinType)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(argument2, "argument");
            if (!TypeUtilsKt.contains(argument2, check.1.INSTANCE)) continue;
            context2.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "'typeOf' with non-reified type parameters is not supported"));
        }
    }

    public final boolean isTypeOf(@NotNull CallableDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        PackageFragmentDescriptor packageFragmentDescriptor;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return Intrinsics.areEqual(descriptor2.getName().asString(), "typeOf") && descriptor2.getValueParameters().isEmpty() && Intrinsics.areEqual((packageFragmentDescriptor = (declarationDescriptor = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null) == null ? null : packageFragmentDescriptor.getFqName(), StandardNames.KOTLIN_REFLECT_FQ_NAME);
    }
}

