/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transport.file;

import javax.inject.Named;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.Transporter;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.Logger;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.LoggerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.NullLoggerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoTransporterException;
import org.jetbrains.kotlin.org.eclipse.aether.transport.file.FileTransporter;

@Named(value="file")
public final class FileTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public FileTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, FileTransporter.class);
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoTransporterException {
        return new FileTransporter(repository, this.logger);
    }
}

