/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transfer;

import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;

public class ChecksumFailureException
extends RepositoryException {
    private final String expected;
    private final String actual;
    private final boolean retryWorthy;

    public ChecksumFailureException(String expected, String actual) {
        super("Checksum validation failed, expected " + expected + " but is " + actual);
        this.expected = expected;
        this.actual = actual;
        this.retryWorthy = true;
    }

    public ChecksumFailureException(String message2) {
        this(false, message2, null);
    }

    public ChecksumFailureException(Throwable cause) {
        this("Checksum validation failed" + ChecksumFailureException.getMessage(": ", cause), cause);
    }

    public ChecksumFailureException(String message2, Throwable cause) {
        this(false, message2, cause);
    }

    public ChecksumFailureException(boolean retryWorthy, String message2, Throwable cause) {
        super(message2, cause);
        this.expected = "";
        this.actual = "";
        this.retryWorthy = retryWorthy;
    }

    public boolean isRetryWorthy() {
        return this.retryWorthy;
    }
}

