/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.repository.internal;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.Versioning;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryEvent;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.SyncContext;
import org.jetbrains.kotlin.org.eclipse.aether.impl.MetadataResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.jetbrains.kotlin.org.eclipse.aether.impl.SyncContextFactory;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.DefaultMetadata;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ArtifactRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceReader;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.MetadataRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.MetadataResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.util.version.GenericVersionScheme;
import org.jetbrains.kotlin.org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.jetbrains.kotlin.org.eclipse.aether.version.Version;
import org.jetbrains.kotlin.org.eclipse.aether.version.VersionConstraint;

@Named
@Singleton
public class DefaultVersionRangeResolver
implements VersionRangeResolver,
Service {
    private MetadataResolver metadataResolver;
    private SyncContextFactory syncContextFactory;
    private RepositoryEventDispatcher repositoryEventDispatcher;

    @Override
    public void initService(ServiceLocator locator) {
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultVersionRangeResolver setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadataResolver cannot be null");
        return this;
    }

    public DefaultVersionRangeResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "syncContextFactory cannot be null");
        return this;
    }

    public DefaultVersionRangeResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session2, VersionRangeRequest request) throws VersionRangeResolutionException {
        VersionConstraint versionConstraint;
        VersionRangeResult result2 = new VersionRangeResult(request);
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionConstraint = versionScheme.parseVersionConstraint(request.getArtifact().getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            result2.addException(e);
            throw new VersionRangeResolutionException(result2);
        }
        result2.setVersionConstraint(versionConstraint);
        if (versionConstraint.getRange() == null) {
            result2.addVersion(versionConstraint.getVersion());
        } else {
            Map<String, ArtifactRepository> versionIndex = this.getVersions(session2, result2, request);
            ArrayList<Version> versions2 = new ArrayList<Version>();
            for (Map.Entry<String, ArtifactRepository> v : versionIndex.entrySet()) {
                try {
                    Version ver = versionScheme.parseVersion(v.getKey());
                    if (!versionConstraint.containsVersion(ver)) continue;
                    versions2.add(ver);
                    result2.setRepository(ver, v.getValue());
                }
                catch (InvalidVersionSpecificationException e) {
                    result2.addException(e);
                }
            }
            Collections.sort(versions2);
            result2.setVersions(versions2);
        }
        return result2;
    }

    private Map<String, ArtifactRepository> getVersions(RepositorySystemSession session2, VersionRangeResult result2, VersionRangeRequest request) {
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        HashMap<String, ArtifactRepository> versionIndex = new HashMap<String, ArtifactRepository>();
        DefaultMetadata metadata2 = new DefaultMetadata(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>(request.getRepositories().size());
        metadataRequests.add(new MetadataRequest(metadata2, null, request.getRequestContext()));
        for (RemoteRepository repository : request.getRepositories()) {
            MetadataRequest metadataRequest = new MetadataRequest(metadata2, repository, request.getRequestContext());
            metadataRequest.setDeleteLocalCopyIfMissing(true);
            metadataRequest.setTrace(trace);
            metadataRequests.add(metadataRequest);
        }
        List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session2, metadataRequests);
        WorkspaceReader workspace = session2.getWorkspaceReader();
        if (workspace != null) {
            List<String> versions2 = workspace.findVersions(request.getArtifact());
            for (String version : versions2) {
                versionIndex.put(version, workspace.getRepository());
            }
        }
        for (MetadataResult metadataResult : metadataResults) {
            result2.addException(metadataResult.getException());
            ArtifactRepository repository = metadataResult.getRequest().getRepository();
            if (repository == null) {
                repository = session2.getLocalRepository();
            }
            Versioning versioning = this.readVersions(session2, trace, metadataResult.getMetadata(), repository, result2);
            for (String version : versioning.getVersions()) {
                if (versionIndex.containsKey(version)) continue;
                versionIndex.put(version, repository);
            }
        }
        return versionIndex;
    }

    private Versioning readVersions(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, ArtifactRepository repository, VersionRangeResult result2) {
        Versioning versioning;
        block26: {
            versioning = null;
            try {
                if (metadata2 == null) break block26;
                SyncContext syncContext = this.syncContextFactory.newInstance(session2, true);
                Throwable throwable = null;
                try {
                    syncContext.acquire(null, Collections.singleton(metadata2));
                    if (metadata2.getFile() == null || !metadata2.getFile().exists()) break block26;
                    FileInputStream in = new FileInputStream(metadata2.getFile());
                    Throwable throwable2 = null;
                    try {
                        versioning = new MetadataXpp3Reader().read(in, false).getVersioning();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in != null) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (syncContext != null) {
                        if (throwable != null) {
                            try {
                                syncContext.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            syncContext.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session2, trace, metadata2, repository, e);
                result2.addException(e);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace);
        event.setMetadata(metadata2);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

