/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.normalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.model.Build;
import org.jetbrains.kotlin.org.apache.maven.model.Dependency;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.model.Plugin;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollector;
import org.jetbrains.kotlin.org.apache.maven.model.merge.MavenModelMerger;
import org.jetbrains.kotlin.org.apache.maven.model.normalization.ModelNormalizer;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultModelNormalizer
implements ModelNormalizer {
    private DuplicateMerger merger = new DuplicateMerger();

    @Override
    public void mergeDuplicates(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        LinkedHashMap<String, Cloneable> normalized;
        Build build2 = model.getBuild();
        if (build2 != null) {
            List<Plugin> plugins = build2.getPlugins();
            normalized = new LinkedHashMap<String, Cloneable>(plugins.size() * 2);
            for (Plugin plugin : plugins) {
                String key = plugin.getKey();
                Plugin first2 = (Plugin)normalized.get(key);
                if (first2 != null) {
                    this.merger.mergePlugin(plugin, first2);
                }
                normalized.put(key, plugin);
            }
            if (plugins.size() != normalized.size()) {
                build2.setPlugins(new ArrayList<Plugin>(normalized.values()));
            }
        }
        List<Dependency> dependencies2 = model.getDependencies();
        normalized = new LinkedHashMap(dependencies2.size() * 2);
        for (Dependency dependency : dependencies2) {
            normalized.put(dependency.getManagementKey(), dependency);
        }
        if (dependencies2.size() != normalized.size()) {
            model.setDependencies(new ArrayList<Dependency>(normalized.values()));
        }
    }

    @Override
    public void injectDefaultValues(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.injectDependencyDefaults(model.getDependencies());
        Build build2 = model.getBuild();
        if (build2 != null) {
            for (Plugin plugin : build2.getPlugins()) {
                this.injectDependencyDefaults(plugin.getDependencies());
            }
        }
    }

    private void injectDependencyDefaults(List<Dependency> dependencies2) {
        for (Dependency dependency : dependencies2) {
            if (!StringUtils.isEmpty(dependency.getScope())) continue;
            dependency.setScope("compile");
        }
    }

    protected static class DuplicateMerger
    extends MavenModelMerger {
        protected DuplicateMerger() {
        }

        public void mergePlugin(Plugin target, Plugin source) {
            super.mergePlugin(target, source, false, Collections.<Object, Object>emptyMap());
        }
    }
}

