/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.ConfigurationContainer;
import org.jetbrains.kotlin.org.apache.maven.model.Dependency;
import org.jetbrains.kotlin.org.apache.maven.model.PluginExecution;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;

public class Plugin
extends ConfigurationContainer
implements Serializable,
Cloneable {
    private String groupId = "org.jetbrains.kotlin.org.apache.maven.plugins";
    private String artifactId;
    private String version;
    private String extensions;
    private List<PluginExecution> executions;
    private List<Dependency> dependencies;
    private Object goals;
    private Map<String, PluginExecution> executionMap = null;
    private String key = null;

    @Override
    public Plugin clone() {
        try {
            Plugin copy2 = (Plugin)super.clone();
            if (this.executions != null) {
                copy2.executions = new ArrayList<PluginExecution>();
                for (PluginExecution pluginExecution : this.executions) {
                    copy2.executions.add(pluginExecution.clone());
                }
            }
            if (this.dependencies != null) {
                copy2.dependencies = new ArrayList<Dependency>();
                for (Dependency dependency : this.dependencies) {
                    copy2.dependencies.add(dependency.clone());
                }
            }
            if (this.goals != null) {
                copy2.goals = new Xpp3Dom((Xpp3Dom)this.goals);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public List<PluginExecution> getExecutions() {
        if (this.executions == null) {
            this.executions = new ArrayList<PluginExecution>();
        }
        return this.executions;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setDependencies(List<Dependency> dependencies2) {
        this.dependencies = dependencies2;
    }

    public void setExecutions(List<PluginExecution> executions) {
        this.executions = executions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public void setGoals(Object goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = Plugin.constructKey(this.groupId, this.artifactId);
        }
        return this.key;
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin)other;
            return this.getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Plugin [" + this.getKey() + "]";
    }
}

