/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.util;

import java.util.Collection;
import org.jetbrains.kotlin.org.apache.http.util.TextUtils;

public class Args {
    public static void check(boolean expression2, String message2) {
        if (!expression2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void check(boolean expression2, String message2, Object ... args2) {
        if (!expression2) {
            throw new IllegalArgumentException(String.format(message2, args2));
        }
    }

    public static <T> T notNull(T argument2, String name2) {
        if (argument2 == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        return argument2;
    }

    public static <T extends CharSequence> T notEmpty(T argument2, String name2) {
        if (argument2 == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (TextUtils.isEmpty(argument2)) {
            throw new IllegalArgumentException(name2 + " may not be empty");
        }
        return argument2;
    }

    public static <T extends CharSequence> T notBlank(T argument2, String name2) {
        if (argument2 == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (TextUtils.isBlank(argument2)) {
            throw new IllegalArgumentException(name2 + " may not be blank");
        }
        return argument2;
    }

    public static <T extends CharSequence> T containsNoBlanks(T argument2, String name2) {
        if (argument2 == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (argument2.length() == 0) {
            throw new IllegalArgumentException(name2 + " may not be empty");
        }
        if (TextUtils.containsBlanks(argument2)) {
            throw new IllegalArgumentException(name2 + " may not contain blanks");
        }
        return argument2;
    }

    public static <E, T extends Collection<E>> T notEmpty(T argument2, String name2) {
        if (argument2 == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (argument2.isEmpty()) {
            throw new IllegalArgumentException(name2 + " may not be empty");
        }
        return argument2;
    }

    public static int positive(int n, String name2) {
        if (n <= 0) {
            throw new IllegalArgumentException(name2 + " may not be negative or zero");
        }
        return n;
    }

    public static int notNegative(int n, String name2) {
        if (n < 0) {
            throw new IllegalArgumentException(name2 + " may not be negative");
        }
        return n;
    }

    public static long notNegative(long n, String name2) {
        if (n < 0L) {
            throw new IllegalArgumentException(name2 + " may not be negative");
        }
        return n;
    }
}

