/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.KotlinClassifiersCacheKt;
import org.jetbrains.kotlin.javac.resolve.MockKotlinClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0004`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/KotlinClassifiersCache;", "", "sourceFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/javac/JavacWrapper;)V", "classifiers", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Lkotlin/collections/HashMap;", "kotlinClasses", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "kotlinFacadeClasses", "kotlinPackages", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "createClassifier", "classId", "createMockKotlinClassifier", "Lorg/jetbrains/kotlin/javac/resolve/MockKotlinClassifier;", "classifier", "ktFile", "getKotlinClassifier", "hasPackage", "", "packageFqName", "javac-wrapper"})
public final class KotlinClassifiersCache {
    @NotNull
    private final JavacWrapper javac;
    @NotNull
    private final HashSet<FqName> kotlinPackages;
    @NotNull
    private final HashMap<ClassId, KtFile> kotlinFacadeClasses;
    @NotNull
    private final Map<ClassId, KtClassOrObject> kotlinClasses;
    @NotNull
    private final HashMap<ClassId, JavaClass> classifiers;

    /*
     * WARNING - void declaration
     */
    public KotlinClassifiersCache(@NotNull Collection<? extends KtFile> sourceFiles2, @NotNull JavacWrapper javac2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(sourceFiles2, "sourceFiles");
        Intrinsics.checkNotNullParameter(javac2, "javac");
        this.javac = javac2;
        this.kotlinPackages = new HashSet();
        this.kotlinFacadeClasses = new HashMap();
        Iterable iterable = sourceFiles2;
        KotlinClassifiersCache kotlinClassifiersCache2 = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            KtFile ktFile = (KtFile)element$iv$iv;
            boolean bl = false;
            this.kotlinPackages.add(ktFile.getPackageFqName());
            FqName facadeFqName = JvmFileClassUtilKt.getJavaFileFacadeFqName(ktFile);
            Object object = this.kotlinFacadeClasses;
            ClassId classId = new ClassId(facadeFqName.parent(), facadeFqName.shortName());
            object.put(classId, ktFile);
            object = ktFile.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            void var15_17 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof KtClassOrObject)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair<ClassId, void> pair = TuplesKt.to(KotlinClassifiersCacheKt.access$computeClassId((KtClassOrObject)it), it);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        kotlinClassifiersCache2.kotlinClasses = MapsKt.toMap(list2);
        this.classifiers = new HashMap();
    }

    @Nullable
    public final JavaClass getKotlinClassifier(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        JavaClass javaClass = this.classifiers.get(classId);
        return javaClass == null ? this.createClassifier(classId) : javaClass;
    }

    @NotNull
    public final MockKotlinClassifier createMockKotlinClassifier(@Nullable KtClassOrObject classifier2, @Nullable KtFile ktFile, @NotNull ClassId classId) {
        MockKotlinClassifier mockKotlinClassifier;
        Intrinsics.checkNotNullParameter(classId, "classId");
        MockKotlinClassifier $this$createMockKotlinClassifier_u24lambda_u2d2 = mockKotlinClassifier = new MockKotlinClassifier(classId, classifier2, ktFile, this, this.javac);
        boolean bl = false;
        Map map2 = this.classifiers;
        map2.put(classId, $this$createMockKotlinClassifier_u24lambda_u2d2);
        return mockKotlinClassifier;
    }

    public final boolean hasPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.kotlinPackages.contains(packageFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final JavaClass createClassifier(ClassId classId) {
        Object object = this.kotlinFacadeClasses.get(classId);
        if (object != null) {
            KtFile ktFile;
            KtFile it = ktFile = object;
            boolean bl = false;
            return this.createMockKotlinClassifier(null, it, classId);
        }
        if (classId.isNestedClass()) {
            JavaClass javaClass;
            Object object2;
            KtClassOrObject $this$mapTo$iv$iv;
            object = this.classifiers.get(classId);
            if (object != null) {
                Object object3;
                Object it = object3 = object;
                boolean bl = false;
                return it;
            }
            List<Name> list2 = classId.getRelativeClassName().pathSegments();
            Intrinsics.checkNotNullExpressionValue(list2, "classId.relativeClassName.pathSegments()");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                Name name2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                object2 = it.asString();
                collection.add(object2);
            }
            List pathSegments = (List)((Object)destination$iv$iv);
            ClassId outerClassId = new ClassId(classId.getPackageFqName(), Name.identifier((String)CollectionsKt.first(pathSegments)));
            JavaClass outerClass2 = null;
            $this$mapTo$iv$iv = this.kotlinClasses.get(outerClassId);
            if ($this$mapTo$iv$iv == null) {
                return null;
            }
            Iterator it = destination$iv$iv = $this$mapTo$iv$iv;
            boolean bl3 = false;
            object2 = this.createMockKotlinClassifier((KtClassOrObject)((Object)it), null, outerClassId);
            outerClass2 = (JavaClass)object2;
            Iterable $this$forEach$iv = CollectionsKt.drop(pathSegments, 1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl4 = false;
                Name name3 = Name.identifier(it2);
                Intrinsics.checkNotNullExpressionValue(name3, "identifier(it)");
                JavaClass javaClass2 = outerClass2.findInnerClass(name3);
                if (javaClass2 == null) {
                    return null;
                }
                outerClass2 = javaClass2;
            }
            JavaClass $this$createClassifier_u24lambda_u2d8 = javaClass = outerClass2;
            boolean bl5 = false;
            Map map2 = this.classifiers;
            map2.put(classId, $this$createClassifier_u24lambda_u2d8);
            return javaClass;
        }
        KtClassOrObject ktClassOrObject = this.kotlinClasses.get(classId);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject kotlinClassifier = ktClassOrObject;
        return this.createMockKotlinClassifier(kotlinClassifier, null, classId);
    }
}

