/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.util.Set;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.internal.AbstractBindingProcessor;
import org.jetbrains.kotlin.com.google.inject.internal.BindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.BoundProviderFactory;
import org.jetbrains.kotlin.com.google.inject.internal.ConstantFactory;
import org.jetbrains.kotlin.com.google.inject.internal.ConstructorBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.ErrorsException;
import org.jetbrains.kotlin.com.google.inject.internal.ExposedBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.ExposedKeyFactory;
import org.jetbrains.kotlin.com.google.inject.internal.FactoryProxy;
import org.jetbrains.kotlin.com.google.inject.internal.Initializable;
import org.jetbrains.kotlin.com.google.inject.internal.Initializer;
import org.jetbrains.kotlin.com.google.inject.internal.InstanceBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalFactory;
import org.jetbrains.kotlin.com.google.inject.internal.InternalFactoryToInitializableAdapter;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProviderInstanceBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.LinkedBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.LinkedProviderBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.ProcessedBindingData;
import org.jetbrains.kotlin.com.google.inject.internal.ProviderInstanceBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.ProviderMethod;
import org.jetbrains.kotlin.com.google.inject.internal.Scoping;
import org.jetbrains.kotlin.com.google.inject.spi.ConstructorBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ConvertedConstantBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ExposedBinding;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;
import org.jetbrains.kotlin.com.google.inject.spi.InstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.LinkedKeyBinding;
import org.jetbrains.kotlin.com.google.inject.spi.PrivateElements;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderInstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderKeyBinding;
import org.jetbrains.kotlin.com.google.inject.spi.UntargettedBinding;

final class BindingProcessor
extends AbstractBindingProcessor {
    private final Initializer initializer;

    BindingProcessor(Errors errors, Initializer initializer2, ProcessedBindingData bindingData) {
        super(errors, bindingData);
        this.initializer = initializer2;
    }

    @Override
    public <T> Boolean visit(Binding<T> command2) {
        Class<T> rawType = command2.getKey().getTypeLiteral().getRawType();
        if (Void.class.equals(rawType)) {
            if (command2 instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command2).getUserSuppliedProvider() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        return (Boolean)command2.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)command2){

            @Override
            public Boolean visit(ConstructorBinding<? extends T> binding) {
                this.prepareBinding();
                try {
                    ConstructorBindingImpl onInjector = ConstructorBindingImpl.create(BindingProcessor.this.injector, this.key, binding.getConstructor(), this.source, this.scoping, BindingProcessor.this.errors, false, false);
                    this.scheduleInitialization(onInjector);
                    BindingProcessor.this.putBinding(onInjector);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            public Boolean visit(InstanceBinding<? extends T> binding) {
                this.prepareBinding();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, binding, this.source, injectionPoints);
                ConstantFactory factory2 = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory2, this.source, this.scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, injectionPoints, instance));
                return true;
            }

            @Override
            public Boolean visit(ProviderInstanceBinding<? extends T> binding) {
                this.prepareBinding();
                javax.inject.Provider provider2 = binding.getUserSuppliedProvider();
                if (provider2 instanceof InternalProviderInstanceBindingImpl.Factory) {
                    InternalProviderInstanceBindingImpl.Factory asProviderMethod = (InternalProviderInstanceBindingImpl.Factory)provider2;
                    return this.visitInternalProviderInstanceBindingFactory(asProviderMethod);
                }
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider2, null, this.source, injectionPoints);
                InternalFactoryToInitializableAdapter factory2 = new InternalFactoryToInitializableAdapter(initializable, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory2, this.source, this.scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, provider2, injectionPoints));
                return true;
            }

            @Override
            public Boolean visit(ProviderKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                BindingProcessor.this.bindingData.addCreationListener(boundProviderFactory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, boundProviderFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, providerKey));
                return true;
            }

            @Override
            public Boolean visit(LinkedKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key linkedKey = binding.getLinkedKey();
                if (this.key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory2 = new FactoryProxy(BindingProcessor.this.injector, this.key, linkedKey, this.source);
                BindingProcessor.this.bindingData.addCreationListener(factory2);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory2, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, linkedKey));
                return true;
            }

            private Boolean visitInternalProviderInstanceBindingFactory(InternalProviderInstanceBindingImpl.Factory<T> provider2) {
                InternalProviderInstanceBindingImpl binding = new InternalProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, provider2, Scoping.scope(this.key, BindingProcessor.this.injector, provider2, this.source, this.scoping), this.scoping);
                switch (binding.getInitializationTiming()) {
                    case DELAYED: {
                        this.scheduleDelayedInitialization(binding);
                        break;
                    }
                    case EAGER: {
                        this.scheduleInitialization(binding);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                BindingProcessor.this.putBinding(binding);
                return true;
            }

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                return false;
            }

            @Override
            public Boolean visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding) {
                throw new IllegalStateException("BindingProcessor should override all visitations");
            }
        });
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.bindingData.addCreationListener(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>(this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }
}

