/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.FunctionalInterfacesUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0011\u0010%\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\bH\u0096\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\tH\u0016J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001eH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0012H\u0016J\b\u0010.\u001a\u00020\u001eH\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\bH\u0016J\u0018\u00105\u001a\u0002062\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\bH\u0016J\u0018\u00107\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "delegate", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)V", "irBuiltInsMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "isCurrent", "", "()Z", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategy", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "addModuleReachableTopLevel", "", "idSig", "checkIsFunctionInterface", "computeFunctionClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "className", "", "contains", "declareIrSymbol", "symbol", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "fileDeserializers", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "init", "postProcess", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "resolveFunctionalInterface", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "ir.serialization.common"})
public final class IrModuleDeserializerWithBuiltIns
extends IrModuleDeserializer {
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final IrModuleDeserializer delegate;
    @NotNull
    private final Map<IdSignature, IrSymbol> irBuiltInsMap;

    /*
     * WARNING - void declaration
     */
    public IrModuleDeserializerWithBuiltIns(@NotNull IrBuiltIns builtIns, @NotNull IrModuleDeserializer delegate2) {
        Collection<Pair<IdSignature, IrSymbol>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        super(delegate2.getModuleDescriptor(), delegate2.getLibraryAbiVersion());
        this.builtIns = builtIns;
        this.delegate = delegate2;
        Iterable iterable = DeclarationTableKt.getKnownBuiltins(this.builtIns);
        IrModuleDeserializerWithBuiltIns irModuleDeserializerWithBuiltIns = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrSymbol symbol2 = it.getSymbol();
            Pair<IdSignature, IrSymbol> pair = TuplesKt.to(symbol2.getSignature(), symbol2);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        irModuleDeserializerWithBuiltIns.irBuiltInsMap = MapsKt.toMap((Iterable)collection);
    }

    private final boolean checkIsFunctionInterface(IdSignature idSig) {
        IdSignature.CommonSignature publicSig = idSig.asPublic();
        return publicSig != null && FunctionalInterfacesUtilsKt.getFunctionalPackages().contains(publicSig.getPackageFqName()) && ((CharSequence)publicSig.getDeclarationFqName()).length() > 0 && FunctionalInterfacesUtilsKt.getFunctionPattern().matcher(publicSig.getFirstNameSegment()).find();
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Map<IdSignature, IrSymbol> map2;
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        IdSignature topLevel = idSig.topLevelSignature();
        Map<IdSignature, IrSymbol> map3 = map2 = this.irBuiltInsMap;
        if (map3.containsKey(topLevel)) {
            return true;
        }
        return this.checkIsFunctionInterface(topLevel) || this.delegate.contains(idSig);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        return this.delegate.referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        return this.delegate.referencePropertyByLocalSignature(file2, idSignature);
    }

    @Override
    public void deserializeReachableDeclarations() {
        this.delegate.deserializeReachableDeclarations();
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass computeFunctionClass(String className2) {
        int n;
        String string2;
        Object object;
        boolean isSuspend;
        boolean isK;
        block1: {
            void $this$indexOfFirst$iv;
            isK = className2.charAt(0) == 'K';
            isSuspend = (isK ? className2.charAt(1) : className2.charAt(0)) == 'S';
            object = className2;
            String $this$computeFunctionClass_u24lambda_u2d2 = object;
            boolean bl = false;
            CharSequence charSequence2 = $this$computeFunctionClass_u24lambda_u2d2;
            string2 = $this$computeFunctionClass_u24lambda_u2d2;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n2 < n3) {
                int index$iv = n2++;
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl2 = false;
                if (!Character.isDigit(it)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int n4 = n;
        String string3 = string2.substring(n4);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
        int arity = Integer.parseInt(string3, CharsKt.checkRadix(10));
        Object $this$computeFunctionClass_u24lambda_u2d3 = object = this.builtIns;
        boolean bl = false;
        return isK && isSuspend ? ((IrBuiltIns)$this$computeFunctionClass_u24lambda_u2d3).kSuspendFunctionN(arity) : (isK ? ((IrBuiltIns)$this$computeFunctionClass_u24lambda_u2d3).kFunctionN(arity) : (isSuspend ? ((IrBuiltIns)$this$computeFunctionClass_u24lambda_u2d3).suspendFunctionN(arity) : ((IrBuiltIns)$this$computeFunctionClass_u24lambda_u2d3).functionN(arity)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrSymbol resolveFunctionalInterface(IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
        IrSymbol irSymbol2;
        if (symbolKind == BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL) {
            IdSignature.CompositeSignature composite = (IdSignature.CompositeSignature)idSig;
            IdSignature classSignature = ((IdSignature.CompositeSignature)idSig).getContainer();
            IrClassSymbol classSymbol = (IrClassSymbol)this.resolveFunctionalInterface(classSignature, BinarySymbolData.SymbolKind.CLASS_SYMBOL);
            IdSignature.LocalSignature typeParameterSig = (IdSignature.LocalSignature)composite.getInner();
            int typeParameterIndex = typeParameterSig.index();
            IrTypeParameter typeParameter = ((IrClass)classSymbol.getOwner()).getTypeParameters().get(typeParameterIndex);
            return typeParameter.getSymbol();
        }
        IdSignature.CommonSignature classSignature = idSig.asPublic();
        if (classSignature == null) {
            throw new IllegalStateException((idSig + " has to be public").toString());
        }
        IdSignature.CommonSignature publicSig = classSignature;
        List<String> fqnParts = publicSig.getNameSegments();
        String typeParameterSig = CollectionsKt.firstOrNull(fqnParts);
        if (typeParameterSig == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("Expected class name for ", idSig).toString());
        }
        String className2 = typeParameterSig;
        IrClass functionClass = this.computeFunctionClass(className2);
        int n = fqnParts.size();
        switch (n) {
            case 1: {
                boolean bl;
                IrClassSymbol typeParameter;
                IrClassSymbol it = typeParameter = functionClass.getSymbol();
                boolean bl2 = false;
                boolean bl3 = bl = symbolKind == BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                irSymbol2 = typeParameter;
                break;
            }
            case 2: {
                String memberName = fqnParts.get(1);
                Iterable $this$single$iv2 = functionClass.getDeclarations();
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv2) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrDeclarationWithName && Intrinsics.areEqual(((IrDeclarationWithName)it).getName().asString(), memberName))) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                $this$single$iv2 = single$iv;
                IrDeclaration it = (IrDeclaration)((Object)$this$single$iv2);
                boolean bl = false;
                irSymbol2 = it.getSymbol();
                break;
            }
            case 3: {
                void $this$single$iv;
                void $this$filterIsInstanceTo$iv$iv;
                boolean memberName = idSig instanceof IdSignature.AccessorSignature;
                if (_Assertions.ENABLED && !memberName) {
                    String $this$single$iv2 = "Assertion failed";
                    throw new AssertionError((Object)$this$single$iv2);
                }
                boolean bl = memberName = symbolKind == BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                if (_Assertions.ENABLED && !memberName) {
                    String $this$single$iv2 = "Assertion failed";
                    throw new AssertionError((Object)$this$single$iv2);
                }
                String propertyName = fqnParts.get(1);
                String accessorName = fqnParts.get(2);
                Iterable $this$filterIsInstance$iv = functionClass.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable found$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv2 = false;
                Object object = $this$single$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    IrProperty it = (IrProperty)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), propertyName)) continue;
                    if (found$iv2) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv2 = true;
                }
                if (!found$iv2) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object var10_26 = single$iv;
                IrProperty p = var10_26;
                boolean bl5 = false;
                IrSimpleFunction irSimpleFunction = p.getGetter();
                if (irSimpleFunction != null) {
                    Object g = object = irSimpleFunction;
                    boolean bl6 = false;
                    if (Intrinsics.areEqual(g.getName().asString(), accessorName)) {
                        return ((IrSimpleFunction)g).getSymbol();
                    }
                }
                irSimpleFunction = p.getSetter();
                if (irSimpleFunction != null) {
                    Object s = object = irSimpleFunction;
                    boolean bl7 = false;
                    if (Intrinsics.areEqual(s.getName().asString(), accessorName)) {
                        return ((IrSimpleFunction)s).getSymbol();
                    }
                }
                throw new IllegalStateException(Intrinsics.stringPlus("No accessor found for signature ", idSig).toString());
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus("No member found for signature ", idSig).toString());
            }
        }
        return irSymbol2;
    }

    @Override
    @NotNull
    public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        IrSymbol irSymbol2 = this.irBuiltInsMap.get(idSig);
        if (irSymbol2 != null) {
            IrSymbol irSymbol3;
            IrSymbol it = irSymbol3 = irSymbol2;
            boolean bl = false;
            return it;
        }
        IdSignature topLevel = idSig.topLevelSignature();
        if (this.checkIsFunctionInterface(topLevel)) {
            return this.resolveFunctionalInterface(idSig, symbolKind);
        }
        return this.delegate.deserializeIrSymbol(idSig, symbolKind);
    }

    @Override
    public void declareIrSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        IdSignature signature2 = symbol2.getSignature();
        if (signature2 != null && this.checkIsFunctionInterface(signature2)) {
            this.resolveFunctionalInterface(signature2, IrModuleDeserializerKt.kind(symbol2));
        } else {
            this.delegate.declareIrSymbol(symbol2);
        }
    }

    @Override
    public void init() {
        this.delegate.init(this);
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.delegate.getKlib();
    }

    @Override
    @NotNull
    public DeserializationStrategy getStrategy() {
        return this.delegate.getStrategy();
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        this.delegate.addModuleReachableTopLevel(idSig);
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.delegate.getModuleFragment();
    }

    @Override
    @NotNull
    public Collection<IrModuleDeserializer> getModuleDependencies() {
        return this.delegate.getModuleDependencies();
    }

    @Override
    public boolean isCurrent() {
        return this.delegate.isCurrent();
    }

    @Override
    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        return this.delegate.fileDeserializers();
    }

    @Override
    public void postProcess() {
        this.delegate.postProcess();
    }

    @Override
    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return this.delegate.signatureDeserializerForFile(fileName);
    }
}

