/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleIterator;
import gnu.trove.TDoubleProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TDoubleHashSet
extends TDoubleHash {
    public TDoubleHashSet() {
    }

    public TDoubleHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TDoubleHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TDoubleHashSet(double[] array2) {
        this(array2.length);
        this.addAll(array2);
    }

    public TDoubleHashSet(TDoubleHashingStrategy strategy) {
        super(strategy);
    }

    public TDoubleHashSet(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TDoubleHashSet(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TDoubleHashSet(double[] array2, TDoubleHashingStrategy strategy) {
        this(array2.length, strategy);
        this.addAll(array2);
    }

    public TDoubleIterator iterator() {
        return new TDoubleIterator(this);
    }

    public boolean add(double val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        double[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            double o = oldSet[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._states[index2] = 1;
        }
    }

    public double[] toArray() {
        double[] result2 = new double[this.size()];
        double[] set = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                result2[j++] = set[i];
            }
        }
        return result2;
    }

    public void clear() {
        super.clear();
        double[] set = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = set.length;
            while (i-- > 0) {
                set[i] = 0.0;
                states[i] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleHashSet)) {
            return false;
        }
        final TDoubleHashSet that = (TDoubleHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TDoubleProcedure(){

            public final boolean execute(double value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(double val) {
        int index2 = this.index(val);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public boolean containsAll(double[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (this.contains(array2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(double[] array2) {
        boolean changed = false;
        int i = array2.length;
        while (i-- > 0) {
            if (!this.add(array2[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(double[] array2) {
        boolean changed = false;
        int i = array2.length;
        while (i-- > 0) {
            if (!this.remove(array2[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(double[] array2) {
        Arrays.sort(array2);
        double[] set = this._set;
        byte[] states = this._states;
        boolean changed = false;
        if (set != null) {
            int i = set.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array2, set[i]) >= 0) continue;
                this.remove(set[i]);
                changed = true;
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            double val = stream.readDouble();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TDoubleProcedure(){

            public boolean execute(double value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value2);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TDoubleProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double key) {
            this.h += TDoubleHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

