/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import com.sun.jndi.rmi.registry.ReferenceWrapper;
import com.sun.jndi.rmi.registry.RemoteReference;
import java.io.Serializable;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.objectweb.carol.jndi.spi.LocalEnumeration;
import org.objectweb.carol.jndi.spi.SimpleNameParser;
import org.objectweb.carol.jndi.wrapping.JNDIRemoteResource;
import org.objectweb.carol.jndi.wrapping.JNDIResourceWrapper;
import org.objectweb.carol.util.configuration.CarolCurrentConfiguration;

public class JRMPLocalContext
implements Context {
    private Registry registry;
    private static Hashtable environment = null;
    private static final NameParser nameParser = new SimpleNameParser();
    private static Context single = null;
    private static Hashtable wrapperHash = null;

    private JRMPLocalContext(Registry reg, Hashtable env) throws NamingException {
        this.registry = reg;
        wrapperHash = new Hashtable();
        environment = env;
        environment.put("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.JRMPContextWrapperFactory");
    }

    public static Context getSingleInstance(Registry reg, Hashtable env) throws NamingException {
        if (single == null) {
            single = new JRMPLocalContext(reg, env);
        }
        return single;
    }

    private Object unwrapObject(Object o, Name name) throws NamingException {
        try {
            if (o instanceof RemoteReference) {
                Reference objRef = ((RemoteReference)o).getReference();
                ObjectFactory objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                return objFact.getObjectInstance(objRef, name, this, environment);
            }
            if (o instanceof JNDIRemoteResource) {
                return ((JNDIRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("" + e);
        }
    }

    private Object wrapObject(Object o, Name name, boolean replace) throws NamingException {
        try {
            if (!(o instanceof Remote) && o instanceof Referenceable) {
                return new ReferenceWrapper(((Referenceable)o).getReference());
            }
            if (!(o instanceof Remote) && o instanceof Reference) {
                return new ReferenceWrapper((Reference)o);
            }
            if (!(o instanceof Remote) && o instanceof Serializable) {
                JNDIResourceWrapper irw = new JNDIResourceWrapper((Serializable)o);
                CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                JNDIResourceWrapper oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)oldObj);
                    } else {
                        CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            return o;
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public Object lookup(Name name) throws NamingException {
        Remote obj;
        if (name.isEmpty()) {
            return this;
        }
        try {
            obj = this.registry.lookup(name.get(0));
        }
        catch (NotBoundException e) {
            throw new NameNotFoundException(name.get(0));
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return this.unwrapObject(obj, name);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot bind empty name");
        }
        try {
            this.registry.bind(name.get(0), (Remote)this.wrapObject(obj, name, false));
        }
        catch (AlreadyBoundException e) {
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.get(0));
            ne.setRootCause(e);
            throw ne;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot rebind empty name");
        }
        try {
            this.registry.rebind(name.get(0), (Remote)this.wrapObject(obj, name, true));
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        try {
            this.registry.unbind(name.get(0));
            if (wrapperHash.containsKey(name)) {
                CarolCurrentConfiguration.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)wrapperHash.remove(name));
            }
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (wrapperHash.containsKey(oldName)) {
            wrapperHash.put(newName, wrapperHash.remove(oldName));
        }
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public void rename(String name, String newName) throws NamingException {
        this.rename(new CompositeName(name), new CompositeName(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new NamingException("can not list");
        }
        try {
            String[] names = this.registry.list();
            return new LocalEnumeration(this, names);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new NamingException("can not list");
        }
        try {
            String[] names = this.registry.list();
            return new LocalEnumeration(this, names);
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("local operation not implemented");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("local operation not implemented");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("local operation not implemented");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("local operation not implemented");
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        return result.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return environment.remove(propName);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return environment.put(propName, propVal);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)environment.clone();
    }

    public void close() {
    }

    public String getNameInNamespace() {
        return "";
    }
}

