/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.LogBuffer;
import org.objectweb.howl.log.LogFile;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogRecordSizeException;

class BlockLogBuffer
extends LogBuffer {
    long todPut = 0L;
    int initCounter = 0;
    private static final int bufferHeaderSize = 30;
    private int bytesUsedOffset = 0;
    private static final int bufferFooterSize = 18;
    private int recordHeaderSize = 4;
    private byte[] CRLF = "\r\n".getBytes();
    private byte[] crlf = new byte[this.CRLF.length];
    private byte[] HEADER_ID = "HOWL".getBytes();
    private byte[] headerId = new byte[this.HEADER_ID.length];
    private byte[] FOOTER_ID = "LWOH".getBytes();
    private byte[] footerId = new byte[this.FOOTER_ID.length];
    boolean doWrite = true;
    private int maxRecordSize;
    private static final int EOB = 1162822154;
    static final /* synthetic */ boolean $assertionsDisabled;

    BlockLogBuffer(Configuration config) {
        super(config);
    }

    BlockLogBuffer(Configuration config, boolean doWrite) {
        super(config);
        this.doWrite = doWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long put(short type, byte[][] data, boolean sync) throws LogRecordSizeException {
        long logKey = 0L;
        int dataSize = 0;
        int recordSize = this.recordHeaderSize;
        for (int i = 0; i < data.length; ++i) {
            dataSize += data[i].length + 2;
        }
        recordSize += dataSize;
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (recordSize > this.maxRecordSize) {
                throw new LogRecordSizeException(this.maxRecordSize);
            }
            if (recordSize <= this.buffer.remaining()) {
                logKey = (long)this.bsn << 24 | (long)this.buffer.position();
                this.buffer.putShort(type).putShort((short)dataSize);
                for (int i = 0; i < data.length; ++i) {
                    this.buffer.putShort((short)data[i].length);
                    this.buffer.put(data[i]);
                }
                this.todPut = System.currentTimeMillis();
                if (sync) {
                    Object object = this.waitingThreadsLock;
                    synchronized (object) {
                        ++this.waitingThreads;
                    }
                }
            }
        }
        return logKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        if (!$assertionsDisabled && this.lf == null) {
            throw new AssertionError((Object)"LogFile lf is null");
        }
        Object object = this;
        synchronized (object) {
            if (this.iostatus == 1) {
                throw new IOException();
            }
        }
        object = this.waitingThreadsLock;
        synchronized (object) {
            ++this.waitingThreads;
        }
        this.buffer.putInt(this.bytesUsedOffset, this.buffer.position());
        if (this.buffer.remaining() >= 4) {
            try {
                this.buffer.putInt(1162822154);
            }
            catch (BufferOverflowException e) {
                // empty catch block
            }
        }
        int checksumOffset = this.bytesUsedOffset + 4;
        this.buffer.putInt(checksumOffset, 0);
        if (this.doChecksum) {
            int checksum = this.buffer.clear().hashCode();
            this.buffer.putInt(checksumOffset, checksum);
        }
        try {
            BlockLogBuffer checksum = this;
            synchronized (checksum) {
                this.iostatus = 1;
            }
            this.buffer.clear();
            if (this.doWrite) {
                this.lf.write(this);
            }
        }
        catch (IOException e) {
            this.ioexception = e;
            this.iostatus = 3;
            throw e;
        }
    }

    LogBuffer init(int bsn, LogFileManager lfm) throws LogFileOverflowException {
        this.bsn = bsn;
        this.tod = this.todPut = System.currentTimeMillis();
        this.iostatus = 0;
        ++this.initCounter;
        int bufferSize = this.buffer.capacity();
        this.buffer.clear();
        this.buffer.position(bufferSize - 18);
        this.buffer.put(this.FOOTER_ID).putInt(bsn).putLong(this.tod).put(this.CRLF);
        this.buffer.clear();
        this.buffer.put(this.HEADER_ID);
        this.buffer.putInt(bsn);
        this.buffer.putInt(bufferSize);
        this.bytesUsedOffset = this.buffer.position();
        this.buffer.putInt(0);
        this.buffer.putInt(0);
        this.buffer.putLong(this.tod);
        this.buffer.put(this.CRLF);
        this.buffer.limit(bufferSize - 18);
        this.maxRecordSize = this.buffer.remaining();
        this.lf = lfm.getLogFileForWrite(this);
        if (!$assertionsDisabled && this.lf == null) {
            throw new AssertionError((Object)"LogFileManager returned null LogFile pointer");
        }
        this.maxRecordSize = this.buffer.remaining();
        return this;
    }

    private boolean compareBytes(byte[] val, byte[] expected) {
        for (int i = 0; i < val.length; ++i) {
            if (val[i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    LogBuffer read(LogFile lf, long position) throws IOException, InvalidLogBufferException, InvalidMarkException {
        if (!$assertionsDisabled && lf == null) {
            throw new AssertionError((Object)"LogFile reference lf is null");
        }
        if (!$assertionsDisabled && this.buffer == null) {
            throw new AssertionError((Object)"ByteBuffer reference is null");
        }
        this.lf = lf;
        this.buffer.clear();
        int bytesRead = -1;
        if (lf.channel.size() > position) {
            bytesRead = lf.channel.read(this.buffer, position);
        }
        if (bytesRead == -1) {
            this.bsn = -1;
            return this;
        }
        if (bytesRead != this.buffer.capacity()) {
            throw new InvalidLogBufferException("FILESIZE Error: bytesRead=" + bytesRead);
        }
        this.buffer.clear();
        this.buffer.get(this.headerId);
        if (!this.compareBytes(this.headerId, this.HEADER_ID)) {
            throw new InvalidLogBufferException("HEADER_ID" + this.bufferInfo());
        }
        this.bsn = this.buffer.getInt();
        int bufferSize = this.buffer.getInt();
        if (bufferSize != this.buffer.capacity()) {
            throw new InvalidLogBufferException("bufferSize" + this.bufferInfo());
        }
        this.bytesUsed = this.buffer.getInt();
        if (this.bytesUsed < 0 || this.bytesUsed >= this.buffer.capacity()) {
            throw new InvalidLogBufferException("data used: " + this.bytesUsed + this.bufferInfo());
        }
        int checksumOffset = this.buffer.position();
        int checkSum = this.buffer.getInt();
        if (checkSum != 0) {
            this.buffer.putInt(checksumOffset, 0);
            int expectedChecksum = this.buffer.clear().hashCode();
            this.buffer.clear().position(checksumOffset);
            this.buffer.putInt(checkSum);
            if (checkSum != expectedChecksum) {
                throw new InvalidLogBufferException("CHECKSUM" + this.bufferInfo());
            }
        }
        this.tod = this.buffer.getLong();
        this.buffer.get(this.crlf);
        if (!this.compareBytes(this.crlf, this.CRLF)) {
            throw new InvalidLogBufferException("HEADER_CRLF" + this.bufferInfo());
        }
        this.buffer.mark();
        this.buffer.position(bufferSize - 18);
        this.buffer.get(this.footerId);
        if (!this.compareBytes(this.footerId, this.FOOTER_ID)) {
            throw new InvalidLogBufferException("FOOTER_ID" + this.bufferInfo());
        }
        int bsn = this.buffer.getInt();
        if (bsn != this.bsn) {
            throw new InvalidLogBufferException("FOOTER_BSN" + this.bufferInfo());
        }
        long tod = this.buffer.getLong();
        if (tod != this.tod) {
            throw new InvalidLogBufferException("FOOTER_TOD" + this.bufferInfo());
        }
        this.buffer.get(this.crlf);
        if (!this.compareBytes(this.crlf, this.CRLF)) {
            throw new InvalidLogBufferException("FOOTER_CRLF" + this.bufferInfo());
        }
        this.buffer.reset();
        return this;
    }

    boolean shouldForce() {
        int forceDelta = this.getWaitingThreads() > 0 ? 50 : 250;
        long now = System.currentTimeMillis();
        return this.todPut + (long)forceDelta < now;
    }

    String getStats() {
        String name = this.getClass().getName();
        String result = "<LogBuffer class='" + name + "' workerID='" + this.index + "'>" + "\n  <timesUsed value='" + this.initCounter + "'>Number of times this buffer was initialized for use</timesUsed>" + "\n  <physicalWrites value='" + this.doWrite + "'>Physical writes " + (this.doWrite ? "enabled" : "disabled") + "</physicalWrites>" + "\n  <checksums value='" + this.doChecksum + "'>Checksum Calculations " + (this.doChecksum ? "enabled" : "disabled") + "</checksums>" + "\n</LogBuffer>" + "\n";
        return result;
    }

    public String bufferInfo() {
        this.buffer.clear();
        StringBuffer sb = new StringBuffer("\nClass: " + this.getClass().getName() + "\n  workerID: " + Integer.toHexString(this.index) + "\n  LogFile: " + this.lf.file.getPath() + "\n  HEADER" + "\n    HEADER_ID: 0x" + Integer.toHexString(this.buffer.getInt()) + "\n    bsn: 0x" + Integer.toHexString(this.buffer.getInt()) + "\n    size: 0x" + Integer.toHexString(this.buffer.getInt()) + "  should be: 0x" + Integer.toHexString(this.buffer.capacity()) + "\n    data used: 0x" + Integer.toHexString(this.buffer.getInt()) + "\n    checkSum: 0x" + Integer.toHexString(this.buffer.getInt()) + "\n    tod: 0x" + Long.toHexString(this.buffer.getLong()) + "\n    crlf: 0x" + Integer.toHexString(this.buffer.getShort()) + "");
        this.buffer.position(this.buffer.capacity() - 18);
        sb.append("\n  FOOTER\n    FOOTER_ID: 0x" + Integer.toHexString(this.buffer.getInt()) + "\n    bsn: 0x" + Integer.toHexString(this.buffer.getInt()) + "\n    tod: 0x" + Long.toHexString(this.buffer.getLong()) + "\n    crlf: 0x" + Integer.toHexString(this.buffer.getShort()) + "");
        return sb.toString();
    }

    static {
        $assertionsDisabled = !BlockLogBuffer.class.desiredAssertionStatus();
    }
}

