/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jetty;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.jetty.Jetty;
import org.jboss.jetty.JettyMBean;
import org.jboss.jetty.JettyServiceMBean;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.AbstractWebDeployer;
import org.jboss.web.WebApplication;
import org.mortbay.util.MultiException;
import org.w3c.dom.Element;

public class JettyService
extends AbstractWebContainer
implements JettyServiceMBean,
MBeanRegistration {
    public static final String NAME = "Jetty";
    protected MBeanServer _server = null;
    protected Jetty _jetty = new Jetty(this);
    protected JettyMBean _jettyBean = null;
    protected Element _jettyConfig = null;
    static /* synthetic */ Class class$org$jboss$web$AbstractWebContainer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jboss$web$AbstractWebDeployer;

    protected void log(MultiException e) {
        this.log.error((Object)"multiple exceptions...");
        Iterator iter = e.getExceptions().iterator();
        while (iter.hasNext()) {
            this.log.error((Object)"exception", (Throwable)((Exception)iter.next()));
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        super.preRegister(server, name);
        name = this.getObjectName(server, name);
        this._server = server;
        return name;
    }

    public void postRegister(Boolean done) {
        super.postRegister(done);
        try {
            this._jettyBean = new JettyMBean(this._jetty);
            this._server.registerMBean((Object)this._jettyBean, null);
        }
        catch (Throwable e) {
            this.log.error((Object)"could not create MBean peers", e);
        }
        this.log.debug((Object)"created MBean peers");
    }

    public String getName() {
        return NAME;
    }

    public void createService() throws Exception {
        super.createService();
        if (this._jettyConfig != null) {
            this._jetty.setConfigurationElement(this._jettyConfig);
        }
    }

    public void startService() throws Exception {
        super.startService();
        try {
            this._jetty.start();
        }
        catch (MultiException e) {
            this.log(e);
        }
        catch (Exception e) {
            this.log.error((Object)"could not start Jetty", (Throwable)e);
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        try {
            this._jetty.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"could not stop Jetty", (Throwable)e);
        }
    }

    public void destroyService() throws Exception {
        super.destroyService();
        try {
            this._jetty.destroy();
            this._jetty = null;
            this._jettyBean = null;
        }
        catch (Throwable e) {
            this.log.error((Object)"could not destroy Jetty", e);
        }
    }

    public void performDeploy(WebApplication webApp, String warUrl, AbstractWebContainer.WebDescriptorParser parser) throws DeploymentException {
        this._jetty.deploy(webApp, warUrl, parser);
    }

    public void performUndeploy(String warUrl) throws DeploymentException {
        this._jetty.undeploy(warUrl);
    }

    public void setJava2ClassLoadingCompliance(boolean loaderCompliance) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("set Java2ClassLoadingCompliance to " + loaderCompliance));
        }
        super.setJava2ClassLoadingCompliance(loaderCompliance);
        this._jetty.setJava2ClassLoadingCompliance(loaderCompliance);
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this._jetty.getJava2ClassLoadingCompliance();
    }

    public boolean getUnpackWars() {
        return this._jetty.getUnpackWars();
    }

    public void setUnpackWars(boolean unpackWars) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("set UnpackWars to " + unpackWars));
        }
        this._jetty.setUnpackWars(unpackWars);
    }

    public boolean getSupportJSR77() {
        return this._jetty.getSupportJSR77();
    }

    public void setSupportJSR77(boolean supportJSR77) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("set SupportJSR77 to " + supportJSR77));
        }
        this._jetty.setSupportJSR77(supportJSR77);
    }

    public String getWebDefaultResource() {
        return this._jetty.getWebDefaultResource();
    }

    public void setWebDefaultResource(String webDefaultResource) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("set WebDefaultResource to " + webDefaultResource));
        }
        this._jetty.setWebDefaultResource(webDefaultResource);
    }

    public Element getConfigurationElement() {
        return this._jettyConfig;
    }

    public void setConfigurationElement(Element configElement) {
        this.log.debug((Object)"Saving Configuration to xml fragment");
        this._jettyConfig = configElement;
    }

    public String getSubjectAttributeName() {
        return this._jetty.getSubjectAttributeName();
    }

    public void setSubjectAttributeName(String subjectAttributeName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("set SubjectAttributeName to " + subjectAttributeName));
        }
        this._jetty.setSubjectAttributeName(subjectAttributeName);
    }

    public AbstractWebDeployer getDeployer(DeploymentInfo di) throws Exception {
        JettyDeployer deployer = new JettyDeployer(di);
        deployer.init(null);
        return deployer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JettyDeployer
    extends AbstractWebDeployer {
        protected DeploymentInfo _deploymentInfo;

        public JettyDeployer(DeploymentInfo di) {
            this._deploymentInfo = di;
        }

        public void init(Object containerConfig) throws Exception {
            this.setLenientEjbLink(JettyService.this.getLenientEjbLink());
            this.setServer(JettyService.this._server);
            try {
                Method method = (class$org$jboss$web$AbstractWebContainer == null ? (class$org$jboss$web$AbstractWebContainer = JettyService.class$("org.jboss.web.AbstractWebContainer")) : class$org$jboss$web$AbstractWebContainer).getDeclaredMethod("getDefaultSecurityDomain", new Class[0]);
                String defaultSecurityDomain = (String)method.invoke((Object)JettyService.this, new Object[0]);
                method = (class$org$jboss$web$AbstractWebDeployer == null ? (class$org$jboss$web$AbstractWebDeployer = JettyService.class$("org.jboss.web.AbstractWebDeployer")) : class$org$jboss$web$AbstractWebDeployer).getDeclaredMethod("setDefaultSecurityDomain", class$java$lang$String == null ? (class$java$lang$String = JettyService.class$("java.lang.String")) : class$java$lang$String);
                method.invoke((Object)this, defaultSecurityDomain);
            }
            catch (Exception e) {
                this.log.info((Object)"Getter/setter for DefaultSecurityDomain not available in this version of JBoss");
            }
        }

        public void performDeploy(WebApplication webApp, String warUrl, AbstractWebContainer.WebDescriptorParser parser) throws DeploymentException {
            JettyService.this.performDeploy(webApp, warUrl, parser);
        }

        public void performUndeploy(String warUrl, WebApplication wa) throws DeploymentException {
            JettyService.this.performUndeploy(warUrl);
        }
    }
}

