/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.multiverse.api.Txn;
import org.multiverse.api.exceptions.DeadTxnException;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.utils.StandardThreadFactory;

public abstract class CommitBarrier {
    private static int corePoolSize = 5;
    private static boolean runAsDaemon = true;
    private static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(corePoolSize, new StandardThreadFactory(5, runAsDaemon));
    private volatile ScheduledExecutorService executorService = EXECUTOR;
    protected final Lock lock;
    protected final Condition statusCondition;
    private volatile Status status;
    private volatile int numberWaiting = 0;
    private List<Runnable> onAbortTasks = new LinkedList<Runnable>();
    private List<Runnable> onCommitTasks = new LinkedList<Runnable>();

    public CommitBarrier(Status status, boolean fair) {
        if (status == null) {
            throw new NullPointerException();
        }
        this.status = status;
        this.lock = new ReentrantLock(fair);
        this.statusCondition = this.lock.newCondition();
    }

    protected final Status getStatus() {
        return this.status;
    }

    public final int getNumberWaiting() {
        return this.numberWaiting;
    }

    public final boolean isClosed() {
        return this.status == Status.Closed;
    }

    public final boolean isCommitted() {
        return this.status == Status.Committed;
    }

    public final boolean isAborted() {
        return this.status == Status.Aborted;
    }

    protected final List<Runnable> signalCommit() {
        this.numberWaiting = 0;
        this.status = Status.Committed;
        this.statusCondition.signalAll();
        this.onAbortTasks = null;
        List<Runnable> result = this.onCommitTasks;
        this.onCommitTasks = new LinkedList<Runnable>();
        return result;
    }

    protected final List<Runnable> signalAborted() {
        this.numberWaiting = 0;
        this.status = Status.Aborted;
        this.statusCondition.signalAll();
        this.onCommitTasks = new LinkedList<Runnable>();
        List<Runnable> result = this.onAbortTasks;
        this.onAbortTasks = new LinkedList<Runnable>();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void abort() {
        postAbortTasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.status.ordinal()]) {
                case 1: {
                    postAbortTasks = this.signalAborted();
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    commitMsg = "Can't abort already committed CommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        CommitBarrier.executeTasks(postAbortTasks);
    }

    protected static void executeTasks(List<Runnable> tasks) {
        if (tasks == null) {
            return;
        }
        for (Runnable task : tasks) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitOpen() throws InterruptedException {
        if (this.status != Status.Closed) {
            return;
        }
        this.lock.lockInterruptibly();
        try {
            while (this.status == Status.Closed) {
                this.statusCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitOpenUninterruptibly() {
        if (this.status == Status.Closed) {
            this.lock.lock();
            try {
                while (this.status == Status.Closed) {
                    this.statusCondition.awaitUninterruptibly();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAwaitOpen(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.status == Status.Closed) {
            long timeoutNs = unit.toNanos(timeout);
            this.lock.lockInterruptibly();
            try {
                while (this.status == Status.Closed) {
                    if ((timeoutNs = this.statusCondition.awaitNanos(timeoutNs)) > 0L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAwaitOpenUninterruptibly(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.status == Status.Closed) {
            long timeoutNs = unit.toNanos(timeout);
            this.lock.lock();
            try {
                while (this.status == Status.Closed) {
                    if ((timeoutNs = this.awaitNanosUninterruptible(timeoutNs)) > 0L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    private long awaitNanosUninterruptible(long timeoutNs) {
        boolean restoreInterrupt = Thread.interrupted();
        while (true) {
            long startNs = System.nanoTime();
            try {
                long l = this.statusCondition.awaitNanos(timeoutNs);
                return l;
            }
            catch (InterruptedException ex) {
                timeoutNs -= System.nanoTime() - startNs;
                restoreInterrupt = true;
            }
        }
        finally {
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setTimeout(long timeout, TimeUnit unit) {
        this.lock.lock();
        try {
            switch (this.status) {
                case Closed: {
                    Runnable command = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CommitBarrier.this.abort();
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                        }
                    };
                    this.executorService.schedule(command, timeout, unit);
                    return;
                }
                case Committed: {
                    String commitMsg = "Can't set a timeout on an already commit CommitBarrier.";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case Aborted: {
                    String abortMsg = "Can't set a timeout on an already aborted CommitBarrier.";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void registerOnAbortTask(Runnable task) {
        this.lock.lock();
        try {
            switch (this.status) {
                case Closed: {
                    if (task == null) {
                        throw new NullPointerException();
                    }
                    if (this.onAbortTasks == null) {
                        this.onAbortTasks = new LinkedList<Runnable>();
                    }
                    this.onAbortTasks.add(task);
                    return;
                }
                case Committed: {
                    String commitMsg = "Can't register on abort task on already committed CommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case Aborted: {
                    String abortMsg = "Can't register on abort task on already aborted CommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void registerOnCommitTask(Runnable task) {
        this.lock.lock();
        try {
            switch (this.status) {
                case Closed: {
                    if (task == null) {
                        throw new NullPointerException();
                    }
                    if (this.onCommitTasks == null) {
                        this.onCommitTasks = new LinkedList<Runnable>();
                    }
                    this.onCommitTasks.add(task);
                    return;
                }
                case Committed: {
                    String commitMsg = "Can't register on commit task on already committed CommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case Aborted: {
                    String abortMsg = "Can't register on commit task on already aborted CommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void addJoiner() {
        if (this.status != Status.Closed) {
            throw new IllegalStateException();
        }
        ++this.numberWaiting;
    }

    protected final void finish(Txn tx) {
        if (tx == null) {
            return;
        }
        if (this.isCommitted()) {
            tx.commit();
        } else if (this.isAborted()) {
            tx.abort();
            throw new IllegalStateException(String.format("[%s] Didn't expect to encounter an aborted CommitBarrier", tx.getConfig().getFamilyName()));
        }
    }

    protected static void ensureNotDead(Txn tx, String operation) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (!tx.getStatus().isAlive()) {
            throw new DeadTxnException(String.format("[%s] Txn can't be used for %s since it isn't alive", tx.getConfig().getFamilyName(), operation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void joinCommit(Txn tx) throws InterruptedException {
        CommitBarrier.ensureNotDead(tx, "joinCommit");
        tasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.status.ordinal()]) {
                case 1: {
                    tx.prepare();
                    this.addJoiner();
                    if (this.isLastParty()) {
                        tasks = this.signalCommit();
                        ** break;
lbl12:
                        // 1 sources

                    } else {
                        while (this.status == Status.Closed) {
                            try {
                                this.statusCondition.await();
                            }
                            catch (InterruptedException ex) {
                                this.signalAborted();
                                tx.abort();
                                throw ex;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    committedMsg = String.format("Can't await commit on already committed VetoCommitBarrier with transaction %s", new Object[]{tx.getConfig().getFamilyName()});
                    throw new CommitBarrierOpenException(committedMsg);
                }
                case 2: {
                    abortMsg = String.format("Can't await commit on already aborted VetoCommitBarrier with transaction %s", new Object[]{tx.getConfig().getFamilyName()});
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        CommitBarrier.executeTasks(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void joinCommitUninterruptibly(Txn tx) {
        CommitBarrier.ensureNotDead(tx, "joinCommitUninterruptibly");
        postCommitTasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.status.ordinal()]) {
                case 1: {
                    tx.prepare();
                    this.addJoiner();
                    if (this.isLastParty()) {
                        postCommitTasks = this.signalCommit();
                        ** break;
lbl12:
                        // 1 sources

                    } else {
                        while (this.status == Status.Closed) {
                            this.statusCondition.awaitUninterruptibly();
                        }
                    }
                    break;
                }
                case 2: {
                    tx.abort();
                    abortedMsg = String.format("Can't call joinCommitUninterruptible on already aborted CountDownCommitBarrier with transaction %s ", new Object[]{tx.getConfig().getFamilyName()});
                    throw new CommitBarrierOpenException(abortedMsg);
                }
                case 3: {
                    tx.abort();
                    commitMsg = String.format("Can't call joinCommitUninterruptible on already committed CountDownCommitBarrier with transaction %s ", new Object[]{tx.getConfig().getFamilyName()});
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        CommitBarrier.executeTasks(postCommitTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean tryJoinCommit(Txn tx) {
        CommitBarrier.ensureNotDead(tx, "tryJoinCommit");
        postCommitTasks = null;
        abort = true;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.status.ordinal()]) {
                case 1: {
                    tx.prepare();
                    this.addJoiner();
                    if (this.isLastParty()) {
                        postCommitTasks = this.signalCommit();
                        abort = false;
                        ** break;
lbl14:
                        // 1 sources

                    } else {
                        postCommitTasks = this.signalAborted();
                        ** break;
                    }
lbl17:
                    // 1 sources

                    break;
                }
                case 2: {
                    abortMsg = String.format("[%s] Can't call tryJoinCommit on already aborted CountDownCommitBarrier", new Object[]{tx.getConfig().getFamilyName()});
                    throw new CommitBarrierOpenException(abortMsg);
                }
                case 3: {
                    commitMsg = String.format("[%s] Can't call tryJoinCommit on already committed CountDownCommitBarrier", new Object[]{tx.getConfig().getFamilyName()});
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
            if (abort) {
                tx.abort();
            } else {
                tx.commit();
            }
        }
        CommitBarrier.executeTasks(postCommitTasks);
        return this.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean tryJoinCommit(Txn tx, long timeout, TimeUnit unit) throws InterruptedException {
        CommitBarrier.ensureNotDead(tx, "tryJoinCommit");
        timeoutNs = unit.toNanos(timeout);
        postCommitTasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.status.ordinal()]) {
                case 1: {
                    tx.prepare();
                    this.addJoiner();
                    if (this.isLastParty()) {
                        postCommitTasks = this.signalCommit();
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    while (this.status == Status.Closed) {
                        try {
                            timeoutNs = this.statusCondition.awaitNanos(timeoutNs);
                            if (timeoutNs > 0L) continue;
                            this.signalAborted();
                            tx.abort();
                            var8_6 = false;
                            return var8_6;
                        }
                        catch (InterruptedException ex) {
                            this.signalAborted();
                            tx.abort();
                            throw ex;
                        }
                    }
                    break;
                }
                case 3: {
                    commitMsg = "Can't await commit on an already committed VetoCommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case 2: {
                    abortMsg = "Can't await commit on an already aborted VetoCommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new NullPointerException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        CommitBarrier.executeTasks(postCommitTasks);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryJoinCommitUninterruptibly(Txn tx, long timeout, TimeUnit unit) {
        CommitBarrier.ensureNotDead(tx, "tryJoinCommitUninterruptibly");
        long timeoutNs = unit.toNanos(timeout);
        this.lock.lock();
        try {
            switch (this.status) {
                case Closed: {
                    tx.prepare();
                    this.addJoiner();
                    while (this.status == Status.Closed) {
                        try {
                            timeoutNs = this.statusCondition.awaitNanos(timeoutNs);
                            if (timeoutNs > 0L) continue;
                            this.signalAborted();
                            tx.abort();
                            boolean bl = false;
                            return bl;
                        }
                        catch (InterruptedException ex) {
                            this.signalAborted();
                            tx.abort();
                            throw new RuntimeException(ex);
                        }
                    }
                    break;
                }
                case Committed: {
                    String commitMsg = "Can't await commit on an already committed VetoCommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case Aborted: {
                    String abortMsg = "Can't await commit on an already aborted VetoCommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new NullPointerException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        throw new TodoException();
    }

    protected abstract boolean isLastParty();

    static enum Status {
        Closed,
        Committed,
        Aborted;

    }
}

