/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.group;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.BlockingActor;
import groovyx.gpars.actor.DefaultActor;
import groovyx.gpars.actor.DynamicDispatchActor;
import groovyx.gpars.actor.ReactiveActor;
import groovyx.gpars.actor.StaticDispatchActor;
import groovyx.gpars.actor.impl.RunnableBackedBlockingActor;
import groovyx.gpars.agent.Agent;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.LazyDataflowVariable;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.Select;
import groovyx.gpars.dataflow.SelectableChannel;
import groovyx.gpars.dataflow.operator.DataflowOperator;
import groovyx.gpars.dataflow.operator.DataflowPrioritySelector;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.DataflowProcessorAtomicBoundAllClosure;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.scheduler.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class PGroup {
    protected static final String A_SPLITTER_NEEDS_AN_INPUT_CHANNEL_AND_AT_LEAST_ONE_OUTPUT_CHANNEL_TO_BE_CREATED = "A splitter needs an input channel and at least one output channel to be created.";
    private final Pool threadPool;

    public Pool getThreadPool() {
        return this.threadPool;
    }

    protected PGroup(Pool threadPool) {
        this.threadPool = threadPool;
    }

    public final DefaultActor actor(@DelegatesTo(value=DefaultActor.class) Runnable handler) {
        DefaultActor actor = new DefaultActor(handler);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final BlockingActor blockingActor(@DelegatesTo(value=BlockingActor.class) Runnable handler) {
        RunnableBackedBlockingActor actor = new RunnableBackedBlockingActor(handler);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final DefaultActor fairActor(@DelegatesTo(value=DefaultActor.class) Runnable handler) {
        DefaultActor actor = new DefaultActor(handler);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final Actor reactor(@DelegatesTo(value=Actor.class) Closure code) {
        ReactiveActor actor = new ReactiveActor(code);
        ((Actor)actor).setParallelGroup(this);
        ((Actor)actor).start();
        return actor;
    }

    public final Actor fairReactor(@DelegatesTo(value=Actor.class) Closure code) {
        ReactiveActor actor = new ReactiveActor(code);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final Actor messageHandler(@DelegatesTo(value=Actor.class) Closure code) {
        DynamicDispatchActor actor = new DynamicDispatchActor().become(code);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final Actor fairMessageHandler(@DelegatesTo(value=Actor.class) Closure code) {
        DynamicDispatchActor actor = new DynamicDispatchActor().become(code);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final Actor staticMessageHandler(final @DelegatesTo(value=Actor.class) Closure code) {
        StaticDispatchActor<Object> actor = new StaticDispatchActor<Object>(){

            @Override
            public void onMessage(Object message) {
                code.call(message);
            }
        };
        code.setDelegate((Object)actor);
        code.setResolveStrategy(1);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final Actor fairStaticMessageHandler(final @DelegatesTo(value=Actor.class) Closure code) {
        StaticDispatchActor<Object> actor = new StaticDispatchActor<Object>(){

            @Override
            public void onMessage(Object message) {
                code.call(message);
            }
        };
        code.setDelegate((Object)actor);
        code.setResolveStrategy(1);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final <T> Agent<T> agent(T state) {
        Agent<T> safe = new Agent<T>(state);
        safe.attachToThreadPool(this.threadPool);
        return safe;
    }

    public final <T> Agent<T> agent(T state, Closure copy) {
        Agent<T> safe = new Agent<T>(state, copy);
        safe.attachToThreadPool(this.threadPool);
        return safe;
    }

    public final <T> Agent<T> fairAgent(T state) {
        Agent<T> safe = this.agent(state);
        safe.makeFair();
        return safe;
    }

    public final <T> Agent<T> fairAgent(T state, Closure copy) {
        Agent<T> safe = this.agent(state, copy);
        safe.makeFair();
        return safe;
    }

    public final <T> Promise<T> task(Closure<T> code) {
        final Closure clonedCode = (Closure)code.clone();
        return this.task(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return clonedCode.call();
            }
        });
    }

    public final <T> Promise<T> task(final Callable<T> callable) {
        final DataflowVariable result = new DataflowVariable();
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dataflow.activeParallelGroup.set(PGroup.this);
                try {
                    try {
                        result.bind(callable.call());
                    }
                    catch (Throwable e) {
                        result.bind(e);
                    }
                }
                finally {
                    Dataflow.activeParallelGroup.remove();
                }
            }
        });
        return result;
    }

    public final Promise<Object> task(final Runnable code) {
        if (code instanceof Closure) {
            return this.task((Closure)code);
        }
        final DataflowVariable<Object> result = new DataflowVariable<Object>();
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dataflow.activeParallelGroup.set(PGroup.this);
                try {
                    try {
                        code.run();
                        result.bind(null);
                    }
                    catch (Throwable e) {
                        result.bind(e);
                    }
                }
                finally {
                    Dataflow.activeParallelGroup.remove();
                }
            }
        });
        return result;
    }

    public final <T> Promise<T> lazyTask(Closure<T> code) {
        Closure clonedCode = (Closure)code.clone();
        return new LazyDataflowVariable(this, clonedCode);
    }

    public final <T> Promise<T> lazyTask(final Callable<T> callable) {
        if (callable instanceof Closure) {
            return this.lazyTask((Closure)callable);
        }
        return new LazyDataflowVariable(this, new Closure<T>(this){

            public int getMaximumNumberOfParameters() {
                return 0;
            }

            public T call() {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public final DataflowProcessor operator(Map channels, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        return new DataflowOperator(this, channels, code).start();
    }

    public final DataflowProcessor operator(List inputChannels, List outputChannels, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        HashMap<String, List> params = new HashMap<String, List>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowOperator(this, params, code).start();
    }

    public final DataflowProcessor operator(List inputChannels, List outputChannels, int maxForks, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        params.put("maxForks", maxForks);
        return new DataflowOperator(this, params, code).start();
    }

    public final DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(5);
        params.put("inputs", Arrays.asList(input));
        params.put("outputs", Arrays.asList(output));
        return new DataflowOperator(this, params, code).start();
    }

    public final DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, int maxForks, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", Arrays.asList(input));
        params.put("outputs", Arrays.asList(output));
        params.put("maxForks", maxForks);
        return new DataflowOperator(this, params, code).start();
    }

    public final DataflowProcessor selector(Map channels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        return new DataflowSelector(this, channels, code).start();
    }

    public final DataflowProcessor selector(List inputChannels, List outputChannels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        HashMap<String, List> params = new HashMap<String, List>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowSelector(this, params, code).start();
    }

    public final DataflowProcessor selector(Map channels) {
        return new DataflowSelector(this, channels, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public final DataflowProcessor selector(List inputChannels, List outputChannels) {
        HashMap<String, List> params = new HashMap<String, List>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowSelector(this, params, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public final DataflowProcessor prioritySelector(Map channels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        return new DataflowPrioritySelector(this, (Map<String, Object>)channels, code).start();
    }

    public final DataflowProcessor prioritySelector(List inputChannels, List outputChannels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowPrioritySelector(this, params, code).start();
    }

    public final DataflowProcessor prioritySelector(Map channels) {
        return new DataflowPrioritySelector(this, (Map<String, Object>)channels, (Closure)new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public final DataflowProcessor prioritySelector(List inputChannels, List outputChannels) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowPrioritySelector(this, params, (Closure)new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public final DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels) {
        if (inputChannel == null || outputChannels == null || outputChannels.isEmpty()) {
            throw new IllegalArgumentException(A_SPLITTER_NEEDS_AN_INPUT_CHANNEL_AND_AT_LEAST_ONE_OUTPUT_CHANNEL_TO_BE_CREATED);
        }
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(5);
        params.put("inputs", Arrays.asList(inputChannel));
        params.put("outputs", outputChannels);
        return new DataflowOperator(this, params, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public final DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels, int maxForks) {
        if (inputChannel == null || outputChannels == null || outputChannels.isEmpty()) {
            throw new IllegalArgumentException(A_SPLITTER_NEEDS_AN_INPUT_CHANNEL_AND_AT_LEAST_ONE_OUTPUT_CHANNEL_TO_BE_CREATED);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", Arrays.asList(inputChannel));
        params.put("outputs", outputChannels);
        params.put("maxForks", maxForks);
        return new DataflowOperator(this, params, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public final Select select(SelectableChannel ... channels) {
        return new Select(this, channels);
    }

    public final Select select(List<SelectableChannel> channels) {
        return new Select(this, channels);
    }

    public final <T> Promise<T> whenAllBound(List<Promise> promises, Closure<T> code) {
        return this.whenAllBound(promises, code, null);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Closure<T> code) {
        return this.whenAllBound(Arrays.asList(promise1), code, null);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Closure<T> code) {
        return this.whenAllBound(Arrays.asList(promise1, promise2), code, null);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Closure<T> code) {
        return this.whenAllBound(Arrays.asList(promise1, promise2, promise3), code, null);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Promise promise4, Closure<T> code) {
        return this.whenAllBound(Arrays.asList(promise1, promise2, promise3, promise4), code, null);
    }

    public final <T> Promise<T> whenAllBound(List<Promise> promises, Closure<T> code, Closure<T> errorHandler) {
        if (promises.size() != code.getMaximumNumberOfParameters() && !PGroup.isListAccepting(code)) {
            throw new IllegalArgumentException("Cannot run whenAllBound(), since the number of promises does not match the number of arguments to the supplied closure.");
        }
        for (Promise promise : promises) {
            promise.touch();
        }
        DataflowVariable result = new DataflowVariable();
        this.whenAllBound(promises, 0, new ArrayList<Object>(promises.size()), result, code, errorHandler);
        return result;
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Closure<T> code, Closure<T> errorHandler) {
        return this.whenAllBound(Arrays.asList(promise1), code, errorHandler);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Closure<T> code, Closure<T> errorHandler) {
        return this.whenAllBound(Arrays.asList(promise1, promise2), code, errorHandler);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Closure<T> code, Closure<T> errorHandler) {
        return this.whenAllBound(Arrays.asList(promise1, promise2, promise3), code, errorHandler);
    }

    public final <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Promise promise4, Closure<T> code, Closure<T> errorHandler) {
        return this.whenAllBound(Arrays.asList(promise1, promise2, promise3, promise4), code, errorHandler);
    }

    private <T> void whenAllBound(final List<Promise> promises, final int index, final List<Object> values, final DataflowVariable<T> result, final Closure<T> code, final Closure<T> errorHandler) {
        block5: {
            if (index == promises.size()) {
                try {
                    if (PGroup.isListAccepting(code)) {
                        result.leftShift(code.call(values));
                        break block5;
                    }
                    result.leftShift(code.call(values.toArray()));
                }
                catch (Throwable e) {
                    result.bindError(e);
                }
            } else {
                promises.get(index).then(this, new MessagingRunnable<Object>(){

                    @Override
                    protected void doRun(Object argument) {
                        values.add(argument);
                        PGroup.this.whenAllBound(promises, index + 1, values, result, code, errorHandler);
                    }
                }, new MessagingRunnable(){

                    protected void doRun(Object argument) {
                        if (errorHandler != null && PGroup.this.shallHandle(errorHandler, (Throwable)argument)) {
                            try {
                                result.leftShift(errorHandler.getMaximumNumberOfParameters() == 1 ? errorHandler.call(argument) : errorHandler.call());
                            }
                            catch (Throwable e) {
                                result.bindError(e);
                            }
                        } else {
                            result.bindError((Throwable)argument);
                        }
                    }
                });
            }
        }
    }

    private <T> boolean shallHandle(Closure<T> errorHandler, Throwable e) {
        Class[] types = errorHandler.getParameterTypes();
        if (types.length == 0) {
            return true;
        }
        return types[0].isAssignableFrom(e.getClass());
    }

    private static <T> boolean isListAccepting(Closure<T> code) {
        return code.getMaximumNumberOfParameters() == 1 && List.class.isAssignableFrom(code.getParameterTypes()[0]);
    }

    protected void finalize() throws Throwable {
        this.threadPool.shutdown();
        super.finalize();
    }

    public void resize(int poolSize) {
        this.threadPool.resize(poolSize);
    }

    public void resetDefaultSize() {
        this.threadPool.resetDefaultSize();
    }

    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }
}

