/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import org.testng.ISuite;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;
import org.testng.xml.XmlTest;

public class TestPanel
extends BaseMultiSuitePanel {
    public TestPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "testlist-";
    }

    @Override
    public String getHeader(ISuite iSuite) {
        return "Tests for " + iSuite.getName();
    }

    @Override
    public String getContent(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        xMLStringBuffer2.push("ul");
        for (XmlTest xmlTest : iSuite.getXmlSuite().getTests()) {
            xMLStringBuffer2.push("li");
            int n = xmlTest.getXmlClasses().size();
            String string = xmlTest.getName() + " (" + TestPanel.pluralize(n, "class") + ")";
            xMLStringBuffer2.addRequired("span", string, "class", "test-name");
            xMLStringBuffer2.pop("li");
        }
        xMLStringBuffer2.pop("ul");
        return xMLStringBuffer2.toXML();
    }

    @Override
    public String getNavigatorLink(ISuite iSuite) {
        return TestPanel.pluralize(iSuite.getXmlSuite().getTests().size(), "test");
    }

    @Override
    public String getClassName() {
        return "test-stats";
    }
}

