/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.util;

import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.util.OutgoingHttpRequestProcessor;
import io.micronaut.http.util.OutgointRequestProcessorMatcher;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class OutgoingHttpRequestProcessorImpl
implements OutgoingHttpRequestProcessor {
    @Override
    public boolean shouldProcessRequest(OutgointRequestProcessorMatcher matcher, HttpRequest<?> request) {
        Optional serviceId = request.getAttribute(HttpAttributes.SERVICE_ID.toString(), String.class);
        String uri = request.getUri().toString();
        return this.shouldProcessRequest(matcher, serviceId.orElse(null), uri);
    }

    public boolean shouldProcessRequest(OutgointRequestProcessorMatcher matcher, String serviceId, String uri) {
        if (matcher.getServiceIdPattern() != null && serviceId != null && matcher.getServiceIdPattern().matcher(serviceId).matches()) {
            return true;
        }
        return matcher.getUriPattern() != null && uri != null && matcher.getUriPattern().matcher(uri).matches();
    }
}

