/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final int BUFFER_MAX = 8192;

    @Blocking
    public static void eachFile(@NonNull URL url, String path, @NonNull Consumer<Path> consumer) {
        try {
            IOUtils.eachFile(url.toURI(), path, consumer);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static void eachFile(@NonNull URI uri, String path, @NonNull Consumer<Path> consumer) {
        block25: {
            try {
                Path myPath;
                FileSystem fileSystem;
                block24: {
                    String scheme = uri.getScheme();
                    fileSystem = null;
                    try {
                        if ("jar".equals(scheme)) {
                            try {
                                fileSystem = FileSystems.getFileSystem(uri);
                            }
                            catch (FileSystemNotFoundException e) {
                                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                            }
                            myPath = fileSystem.getPath(path, new String[0]);
                            break block24;
                        }
                        myPath = "file".equals(scheme) ? Paths.get(uri).resolve(path) : Paths.get(uri);
                    }
                    catch (FileSystemNotFoundException e) {
                        myPath = null;
                    }
                }
                if (myPath == null) break block25;
                try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                    Iterator it = walk.iterator();
                    while (it.hasNext()) {
                        Path currentPath = (Path)it.next();
                        if (currentPath.equals(myPath) || Files.isHidden(currentPath) || currentPath.getFileName().startsWith(".")) continue;
                        consumer.accept(currentPath);
                    }
                }
                finally {
                    if (fileSystem != null && fileSystem.isOpen()) {
                        fileSystem.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static String readText(BufferedReader reader) throws IOException {
        StringBuilder answer = new StringBuilder();
        if (reader == null) {
            return answer.toString();
        }
        char[] charBuffer = new char[8192];
        try {
            int nbCharRead;
            while ((nbCharRead = reader.read(charBuffer)) != -1) {
                answer.append(charBuffer, 0, nbCharRead);
            }
            BufferedReader temp = reader;
            reader = null;
            ((Reader)temp).close();
        }
        finally {
            block11: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    if (!IOLogging.LOG.isWarnEnabled()) break block11;
                    IOLogging.LOG.warn("Failed to close reader: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer.toString();
    }

    private static final class IOLogging {
        private static final Logger LOG = LoggerFactory.getLogger(IOLogging.class);

        private IOLogging() {
        }
    }
}

