/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Objects;

@Internal
class DefaultFieldInjectionPoint<B, T>
implements FieldInjectionPoint<B, T>,
EnvironmentConfigurable {
    private final BeanDefinition declaringBean;
    private final Class declaringType;
    private final Class<T> fieldType;
    private final String field;
    private final AnnotationMetadata annotationMetadata;
    private final Argument[] typeArguments;
    private Environment environment;

    DefaultFieldInjectionPoint(BeanDefinition declaringBean, Class declaringType, Class<T> fieldType, String field, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument[] typeArguments) {
        this.declaringBean = declaringBean;
        this.declaringType = declaringType;
        this.fieldType = fieldType;
        this.field = field;
        this.annotationMetadata = this.initAnnotationMetadata(annotationMetadata);
        this.typeArguments = ArrayUtils.isEmpty((Object[])typeArguments) ? Argument.ZERO_ARGUMENTS : typeArguments;
    }

    @Override
    public void configure(Environment environment) {
        this.environment = environment;
    }

    public String toString() {
        return this.fieldType.getSimpleName() + " " + this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFieldInjectionPoint that = (DefaultFieldInjectionPoint)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.fieldType, that.fieldType) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.declaringType, this.fieldType, this.field);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public String getName() {
        return this.field;
    }

    @Override
    public Field getField() {
        return ReflectionUtils.getRequiredField((Class)this.declaringType, (String)this.field);
    }

    @Override
    public Class<T> getType() {
        return this.fieldType;
    }

    @Override
    public void set(T instance, Object object) {
        Field field = this.getField();
        try {
            field.setAccessible(true);
            field.set(instance, object);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @NonNull
    public Argument<T> asArgument() {
        return Argument.of(this.fieldType, (String)this.field, (AnnotationMetadata)this.annotationMetadata, (Argument[])this.typeArguments);
    }

    @Override
    public BeanDefinition getDeclaringBean() {
        return this.declaringBean;
    }

    @Override
    public boolean requiresReflection() {
        return false;
    }

    public <T extends Annotation> T synthesize(Class<T> annotationClass) {
        return (T)this.getAnnotationMetadata().synthesize(annotationClass);
    }

    public Annotation[] synthesizeAll() {
        return this.getAnnotationMetadata().synthesizeAll();
    }

    public Annotation[] synthesizeDeclared() {
        return this.getAnnotationMetadata().synthesizeDeclared();
    }

    private AnnotationMetadata initAnnotationMetadata(@Nullable AnnotationMetadata annotationMetadata) {
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            if (annotationMetadata.hasPropertyExpressions()) {
                return new FieldAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata);
            }
            return annotationMetadata;
        }
        if (annotationMetadata != null) {
            return annotationMetadata;
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private final class FieldAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        FieldAnnotationMetadata(DefaultAnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return DefaultFieldInjectionPoint.this.environment;
        }
    }
}

