/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContextConfiguration;
import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.attr.MutableAttributeHolder;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

public interface BeanContext
extends LifeCycle<BeanContext>,
ExecutionHandleLocator,
BeanLocator,
BeanDefinitionRegistry,
ApplicationEventPublisher<Object>,
AnnotationMetadataResolver,
MutableAttributeHolder {
    @NonNull
    public BeanContextConfiguration getContextConfiguration();

    @NonNull
    default public <E> ApplicationEventPublisher<E> getEventPublisher(@NonNull Class<E> eventType) {
        Objects.requireNonNull(eventType, "Event type cannot be null");
        return (ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{eventType}));
    }

    @Override
    @Deprecated
    public void publishEvent(Object var1);

    @Override
    @Deprecated
    default public Future<Void> publishEventAsync(Object event) {
        return ApplicationEventPublisher.super.publishEventAsync(event);
    }

    @NonNull
    public <T> T inject(@NonNull T var1);

    @NonNull
    default public <T> T createBean(@NonNull Class<T> beanType) {
        return this.createBean(beanType, (Qualifier)null);
    }

    @NonNull
    public <T> T createBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> T createBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2, @Nullable Map<String, Object> var3);

    @NonNull
    public <T> T createBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2, Object ... var3);

    @NonNull
    default public <T> T createBean(@NonNull Class<T> beanType, Object ... args) {
        return this.createBean(beanType, null, args);
    }

    @NonNull
    default public <T> T createBean(@NonNull Class<T> beanType, @Nullable Map<String, Object> argumentValues) {
        return this.createBean(beanType, null, argumentValues);
    }

    @Nullable
    public <T> T destroyBean(@NonNull Class<T> var1);

    @Nullable
    default public <T> T destroyBean(@NonNull Argument<T> beanType) {
        return this.destroyBean(beanType, null);
    }

    @Nullable
    public <T> T destroyBean(@NonNull Argument<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> T destroyBean(@NonNull T var1);

    @NonNull
    public <T> Optional<T> refreshBean(@Nullable BeanIdentifier var1);

    @NonNull
    public ClassLoader getClassLoader();

    @NonNull
    public BeanDefinitionValidator getBeanValidator();

    @Override
    @NonNull
    public <T> BeanContext registerSingleton(@NonNull Class<T> var1, @NonNull T var2, @Nullable Qualifier<T> var3, boolean var4);

    @Override
    default public BeanContext registerSingleton(@NonNull Object singleton) {
        Objects.requireNonNull(singleton, "Argument [singleton] must not be null");
        Class<?> type = singleton.getClass();
        return this.registerSingleton((Class)type, singleton);
    }

    @Override
    default public <T> BeanContext registerSingleton(Class<T> type, T singleton, Qualifier<T> qualifier) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, true);
    }

    @Override
    default public <T> BeanContext registerSingleton(Class<T> type, T singleton) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)null, true);
    }

    @Override
    @NonNull
    default public BeanContext registerSingleton(@NonNull Object singleton, boolean inject) {
        return (BeanContext)BeanDefinitionRegistry.super.registerSingleton(singleton, inject);
    }

    @NonNull
    public static BeanContext run() {
        return (BeanContext)BeanContext.build().start();
    }

    @NonNull
    public static BeanContext build() {
        return new DefaultBeanContext();
    }

    @NonNull
    public static BeanContext run(ClassLoader classLoader) {
        return (BeanContext)BeanContext.build(classLoader).start();
    }

    @NonNull
    public static BeanContext build(ClassLoader classLoader) {
        return new DefaultBeanContext(classLoader);
    }
}

