/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.PushCapableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.bind.binders.CookieAnnotationBinder;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.HeaderAnnotationBinder;
import io.micronaut.http.bind.binders.ParameterAnnotationBinder;
import io.micronaut.http.bind.binders.PathVariableAnnotationBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestAttributeAnnotationBinder;
import io.micronaut.http.bind.binders.RequestBeanAnnotationBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@Singleton
public class DefaultRequestBinderRegistry
implements RequestBinderRegistry {
    private static final long CACHE_MAX_SIZE = 30L;
    private final Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation = new LinkedHashMap<Class<? extends Annotation>, RequestArgumentBinder>();
    private final Map<TypeAndAnnotation, RequestArgumentBinder> byTypeAndAnnotation = new LinkedHashMap<TypeAndAnnotation, RequestArgumentBinder>();
    private final Map<Integer, RequestArgumentBinder> byType = new LinkedHashMap<Integer, RequestArgumentBinder>();
    private final ConversionService<?> conversionService;
    private final Map<TypeAndAnnotation, Optional<RequestArgumentBinder>> argumentBinderCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();

    public DefaultRequestBinderRegistry(ConversionService conversionService, RequestArgumentBinder ... binders) {
        this(conversionService, Arrays.asList(binders));
    }

    @Inject
    public DefaultRequestBinderRegistry(ConversionService conversionService, List<RequestArgumentBinder> binders) {
        this.conversionService = conversionService;
        if (CollectionUtils.isNotEmpty(binders)) {
            for (RequestArgumentBinder binder : binders) {
                this.addRequestArgumentBinder(binder);
            }
        }
        this.registerDefaultConverters(conversionService);
        this.registerDefaultAnnotationBinders(this.byAnnotation);
        this.byType.put(Argument.of(HttpHeaders.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getHeaders()));
        this.byType.put(Argument.of(HttpRequest.class).typeHashCode(), (argument, source) -> {
            Optional<Argument> typeVariable = argument.getFirstTypeVariable().filter(arg -> arg.getType() != Object.class).filter(arg -> arg.getType() != Void.class);
            if (typeVariable.isPresent() && HttpMethod.permitsRequestBody(source.getMethod())) {
                if (source.getBody().isPresent()) {
                    return () -> Optional.of(new FullHttpRequest(source, (Argument)typeVariable.get()));
                }
                return ArgumentBinder.BindingResult.UNSATISFIED;
            }
            return () -> Optional.of(source);
        });
        this.byType.put(Argument.of(PushCapableHttpRequest.class).typeHashCode(), (argument, source) -> {
            if (source instanceof PushCapableHttpRequest) {
                Optional<Argument> typeVariable = argument.getFirstTypeVariable().filter(arg -> arg.getType() != Object.class).filter(arg -> arg.getType() != Void.class);
                if (typeVariable.isPresent() && HttpMethod.permitsRequestBody(source.getMethod())) {
                    if (source.getBody().isPresent()) {
                        return () -> Optional.of(new PushCapableFullHttpRequest((PushCapableHttpRequest)source, (Argument)typeVariable.get()));
                    }
                    return ArgumentBinder.BindingResult.EMPTY;
                }
                return () -> Optional.of((PushCapableHttpRequest)source);
            }
            return ArgumentBinder.BindingResult.UNSATISFIED;
        });
        this.byType.put(Argument.of(HttpParameters.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getParameters()));
        this.byType.put(Argument.of(Cookies.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getCookies()));
        this.byType.put(Argument.of(Cookie.class).typeHashCode(), (context, source) -> {
            String name;
            Cookies cookies = source.getCookies();
            Cookie cookie = cookies.get(name = context.getArgument().getName());
            if (cookie == null) {
                cookie = cookies.get(NameUtils.hyphenate((String)name));
            }
            Cookie finalCookie = cookie;
            return () -> finalCookie != null ? Optional.of(finalCookie) : Optional.empty();
        });
    }

    public <T, ST> void addRequestArgumentBinder(ArgumentBinder<T, ST> binder) {
        if (binder instanceof AnnotatedRequestArgumentBinder) {
            AnnotatedRequestArgumentBinder annotatedRequestArgumentBinder = (AnnotatedRequestArgumentBinder)binder;
            Class annotationType = annotatedRequestArgumentBinder.getAnnotationType();
            if (binder instanceof TypedRequestArgumentBinder) {
                TypedRequestArgumentBinder typedRequestArgumentBinder = (TypedRequestArgumentBinder)binder;
                Argument argumentType = typedRequestArgumentBinder.argumentType();
                this.byTypeAndAnnotation.put(new TypeAndAnnotation(argumentType, annotationType), (RequestArgumentBinder)binder);
                List<Class<?>> superTypes = typedRequestArgumentBinder.superTypes();
                if (CollectionUtils.isNotEmpty(superTypes)) {
                    for (Class<?> superType : superTypes) {
                        this.byTypeAndAnnotation.put(new TypeAndAnnotation(Argument.of(superType), annotationType), (RequestArgumentBinder)binder);
                    }
                }
            } else {
                this.byAnnotation.put(annotationType, annotatedRequestArgumentBinder);
            }
        } else if (binder instanceof TypedRequestArgumentBinder) {
            TypedRequestArgumentBinder typedRequestArgumentBinder = (TypedRequestArgumentBinder)binder;
            this.byType.put(typedRequestArgumentBinder.argumentType().typeHashCode(), typedRequestArgumentBinder);
        }
    }

    public <T> Optional<ArgumentBinder<T, HttpRequest<?>>> findArgumentBinder(Argument<T> argument, HttpRequest<?> source) {
        Optional opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent()) {
            Class annotationType = (Class)opt.get();
            RequestArgumentBinder binder = this.findBinder(argument, annotationType);
            if (binder == null) {
                binder = this.byAnnotation.get(annotationType);
            }
            if (binder != null) {
                return Optional.of(binder);
            }
        } else {
            RequestArgumentBinder binder = this.byType.get(argument.typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
            binder = this.byType.get(Argument.of((Class)argument.getType()).typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
        }
        return Optional.of(new ParameterAnnotationBinder(this.conversionService));
    }

    protected <T> RequestArgumentBinder findBinder(Argument<T> argument, Class<? extends Annotation> annotationType) {
        TypeAndAnnotation key = new TypeAndAnnotation(argument, annotationType);
        return this.argumentBinderCache.computeIfAbsent(key, key1 -> {
            RequestArgumentBinder requestArgumentBinder = this.byTypeAndAnnotation.get(key1);
            if (requestArgumentBinder == null) {
                Argument t;
                Map.Entry<TypeAndAnnotation, RequestArgumentBinder> entry;
                TypeAndAnnotation typeAndAnnotation;
                Class javaType = ((TypeAndAnnotation)key1).type.getType();
                Iterator<Map.Entry<TypeAndAnnotation, RequestArgumentBinder>> iterator = this.byTypeAndAnnotation.entrySet().iterator();
                while (iterator.hasNext() && ((typeAndAnnotation = (entry = iterator.next()).getKey()).annotation != annotationType || !(t = typeAndAnnotation.type).getType().isAssignableFrom(javaType) || (requestArgumentBinder = entry.getValue()) == null)) {
                }
                if (requestArgumentBinder == null) {
                    requestArgumentBinder = this.byTypeAndAnnotation.get(new TypeAndAnnotation(Argument.of((Class)argument.getType()), annotationType));
                }
            }
            return Optional.ofNullable(requestArgumentBinder);
        }).orElse(null);
    }

    protected void registerDefaultConverters(ConversionService<?> conversionService) {
        conversionService.addConverter(CharSequence.class, MediaType.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty((CharSequence)object)) {
                return Optional.empty();
            }
            String str = object.toString();
            try {
                return Optional.of(MediaType.of(str));
            }
            catch (IllegalArgumentException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        });
    }

    protected void registerDefaultAnnotationBinders(Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation) {
        DefaultBodyAnnotationBinder bodyBinder = new DefaultBodyAnnotationBinder(this.conversionService);
        byAnnotation.put(Body.class, bodyBinder);
        CookieAnnotationBinder cookieAnnotationBinder = new CookieAnnotationBinder(this.conversionService);
        byAnnotation.put(cookieAnnotationBinder.getAnnotationType(), cookieAnnotationBinder);
        HeaderAnnotationBinder headerAnnotationBinder = new HeaderAnnotationBinder(this.conversionService);
        byAnnotation.put(headerAnnotationBinder.getAnnotationType(), headerAnnotationBinder);
        ParameterAnnotationBinder parameterAnnotationBinder = new ParameterAnnotationBinder(this.conversionService);
        byAnnotation.put(parameterAnnotationBinder.getAnnotationType(), parameterAnnotationBinder);
        RequestAttributeAnnotationBinder requestAttributeAnnotationBinder = new RequestAttributeAnnotationBinder(this.conversionService);
        byAnnotation.put(requestAttributeAnnotationBinder.getAnnotationType(), requestAttributeAnnotationBinder);
        PathVariableAnnotationBinder pathVariableAnnotationBinder = new PathVariableAnnotationBinder(this.conversionService);
        byAnnotation.put(pathVariableAnnotationBinder.getAnnotationType(), pathVariableAnnotationBinder);
        RequestBeanAnnotationBinder requestBeanAnnotationBinder = new RequestBeanAnnotationBinder(this, this.conversionService);
        byAnnotation.put(requestBeanAnnotationBinder.getAnnotationType(), requestBeanAnnotationBinder);
        if (KotlinUtils.KOTLIN_COROUTINES_SUPPORTED) {
            ContinuationArgumentBinder continuationArgumentBinder = new ContinuationArgumentBinder();
            this.byType.put(continuationArgumentBinder.argumentType().typeHashCode(), continuationArgumentBinder);
        }
    }

    private static final class PushCapableFullHttpRequest<B>
    extends FullHttpRequest<B>
    implements PushCapableHttpRequest<B> {
        public PushCapableFullHttpRequest(PushCapableHttpRequest<B> delegate, Argument<B> bodyType) {
            super(delegate, bodyType);
        }

        @Override
        public PushCapableHttpRequest<B> getDelegate() {
            return (PushCapableHttpRequest)super.getDelegate();
        }

        @Override
        public boolean isServerPushSupported() {
            return this.getDelegate().isServerPushSupported();
        }

        @Override
        public PushCapableHttpRequest<B> serverPush(@NotNull HttpRequest<?> request) {
            this.getDelegate().serverPush(request);
            return this;
        }
    }

    private static final class TypeAndAnnotation {
        private final Argument<?> type;
        private final Class<? extends Annotation> annotation;

        public TypeAndAnnotation(Argument<?> type, Class<? extends Annotation> annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndAnnotation that = (TypeAndAnnotation)o;
            if (!this.type.equalsType(that.type)) {
                return false;
            }
            return this.annotation.equals(that.annotation);
        }

        public int hashCode() {
            int result = this.type.typeHashCode();
            result = 31 * result + this.annotation.hashCode();
            return result;
        }
    }
}

