/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations"})
public class ServiceDescriptionProcessor
extends AbstractInjectAnnotationProcessor {
    private final Map<String, Set<String>> serviceDescriptors = new HashMap<String, Set<String>>();

    @Override
    protected String getIncrementalProcessorType() {
        return "org.gradle.annotation.processing.aggregating";
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("io.micronaut.core.annotation.Generated");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<JavaClassElement> originatingElements = new ArrayList<JavaClassElement>();
        for (TypeElement typeElement : annotations) {
            Set<? extends javax.lang.model.element.Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (javax.lang.model.element.Element element : elements) {
                String serviceName;
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElement2 = (TypeElement)element;
                String name = typeElement2.getQualifiedName().toString();
                Generated generated = element.getAnnotation(Generated.class);
                if (generated == null || !StringUtils.isNotEmpty((CharSequence)(serviceName = generated.service()))) continue;
                this.serviceDescriptors.computeIfAbsent(serviceName, s1 -> new HashSet()).add(name);
                originatingElements.add(new JavaClassElement(typeElement2, AnnotationMetadata.EMPTY_METADATA, null));
            }
        }
        if (roundEnv.processingOver() && !this.serviceDescriptors.isEmpty()) {
            this.classWriterOutputVisitor.writeServiceEntries(this.serviceDescriptors, originatingElements.toArray(Element.EMPTY_ELEMENT_ARRAY));
            this.writeConfigurationMetadata();
        }
        return true;
    }

    private void writeConfigurationMetadata() {
        ConfigurationMetadataBuilder.getConfigurationMetadataBuilder().ifPresent(metadataBuilder -> {
            block8: {
                try {
                    if (!metadataBuilder.hasMetadata()) break block8;
                    ServiceLoader<ConfigurationMetadataWriter> writers = ServiceLoader.load(ConfigurationMetadataWriter.class, this.getClass().getClassLoader());
                    try {
                        for (ConfigurationMetadataWriter writer : writers) {
                            try {
                                writer.write(metadataBuilder, (ClassWriterOutputVisitor)this.classWriterOutputVisitor);
                            }
                            catch (IOException e) {
                                this.warning("Error occurred writing configuration metadata: %s", e.getMessage());
                            }
                        }
                    }
                    catch (ServiceConfigurationError e) {
                        this.warning("Unable to load ConfigurationMetadataWriter due to : %s", e.getMessage());
                    }
                }
                finally {
                    ConfigurationMetadataBuilder.setConfigurationMetadataBuilder(null);
                }
            }
        });
    }
}

