/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.SourceUnit;

@Internal
public class GroovyParameterElement
extends AbstractGroovyElement
implements ParameterElement {
    private final SourceUnit sourceUnit;
    private final Parameter parameter;
    private final GroovyMethodElement methodElement;
    private ClassElement typeElement;
    private ClassElement genericType;

    GroovyParameterElement(GroovyMethodElement methodElement, GroovyVisitorContext visitorContext, Parameter parameter, AnnotationMetadata annotationMetadata) {
        super(visitorContext, (AnnotatedNode)parameter, annotationMetadata);
        this.parameter = parameter;
        this.sourceUnit = visitorContext.getSourceUnit();
        this.methodElement = methodElement;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @Nullable
    public ClassElement getGenericType() {
        if (this.genericType == null) {
            ClassElement type = this.getType();
            this.genericType = this.methodElement.getGenericElement(this.parameter.getType(), type);
        }
        return this.genericType;
    }

    public String getName() {
        return this.parameter.getName();
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public Object getNativeType() {
        return this.parameter;
    }

    @NonNull
    public ClassElement getType() {
        if (this.typeElement == null) {
            this.typeElement = this.visitorContext.getElementFactory().newClassElement(this.parameter.getType(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)this.parameter.getType()));
        }
        return this.typeElement;
    }
}

