/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.processor;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.ScheduledExecutorTaskScheduler;
import io.micronaut.scheduling.TaskExceptionHandler;
import io.micronaut.scheduling.TaskScheduler;
import io.micronaut.scheduling.annotation.Scheduled;
import io.micronaut.scheduling.exceptions.SchedulerConfigurationException;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ScheduledMethodProcessor
implements ExecutableMethodProcessor<Scheduled>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskScheduler.class);
    private static final String MEMBER_FIXED_RATE = "fixedRate";
    private static final String MEMBER_INITIAL_DELAY = "initialDelay";
    private static final String MEMBER_CRON = "cron";
    private static final String MEMBER_FIXED_DELAY = "fixedDelay";
    private static final String MEMBER_SCHEDULER = "scheduler";
    private final BeanContext beanContext;
    private final ConversionService<?> conversionService;
    private final Queue<ScheduledFuture<?>> scheduledTasks = new ConcurrentLinkedDeque();
    private final TaskExceptionHandler<?, ?> taskExceptionHandler;

    public ScheduledMethodProcessor(BeanContext beanContext, Optional<ConversionService<?>> conversionService, TaskExceptionHandler<?, ?> taskExceptionHandler) {
        this.beanContext = beanContext;
        this.conversionService = conversionService.orElse(ConversionService.SHARED);
        this.taskExceptionHandler = taskExceptionHandler;
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        if (!(this.beanContext instanceof ApplicationContext)) {
            return;
        }
        List scheduledAnnotations = method.getAnnotationValuesByType(Scheduled.class);
        for (AnnotationValue scheduledAnnotation : scheduledAnnotations) {
            ScheduledFuture<?> scheduledFuture;
            Duration duration;
            Optional converted;
            String scheduler;
            Optional<TaskScheduler> optionalTaskScheduler;
            String fixedRate = scheduledAnnotation.get((CharSequence)MEMBER_FIXED_RATE, String.class).orElse(null);
            String initialDelayStr = scheduledAnnotation.get((CharSequence)MEMBER_INITIAL_DELAY, String.class).orElse(null);
            Duration initialDelay = null;
            if (StringUtils.hasText((CharSequence)initialDelayStr)) {
                initialDelay = (Duration)this.conversionService.convert((Object)initialDelayStr, Duration.class).orElseThrow(() -> new SchedulerConfigurationException(method, "Invalid initial delay definition: " + initialDelayStr));
            }
            if (!(optionalTaskScheduler = this.beanContext.findBean(TaskScheduler.class, Qualifiers.byName((String)(scheduler = scheduledAnnotation.get((CharSequence)MEMBER_SCHEDULER, String.class).orElse("scheduled"))))).isPresent()) {
                optionalTaskScheduler = this.beanContext.findBean(ExecutorService.class, Qualifiers.byName((String)scheduler)).filter(ScheduledExecutorService.class::isInstance).map(ScheduledExecutorTaskScheduler::new);
            }
            TaskScheduler taskScheduler = (TaskScheduler)optionalTaskScheduler.orElseThrow(() -> new SchedulerConfigurationException(method, "No scheduler of type TaskScheduler configured for name: " + scheduler));
            Runnable task = () -> {
                Qualifier qualifer = beanDefinition.getAnnotationTypeByStereotype("javax.inject.Qualifier").map(type -> Qualifiers.byAnnotation((AnnotationMetadata)beanDefinition, (Class)type)).orElse(null);
                Class beanType = beanDefinition.getBeanType();
                Object bean = null;
                try {
                    bean = this.beanContext.getBean(beanType, qualifer);
                    if (method.getArguments().length == 0) {
                        method.invoke(bean, new Object[0]);
                    }
                }
                catch (Throwable e) {
                    Qualifier qualifier = Qualifiers.byTypeArguments((Class[])new Class[]{beanType, e.getClass()});
                    Collection definitions = this.beanContext.getBeanDefinitions(TaskExceptionHandler.class, qualifier);
                    Optional<BeanDefinition> mostSpecific = definitions.stream().filter(def -> {
                        List typeArguments = def.getTypeArguments(TaskExceptionHandler.class);
                        if (typeArguments.size() == 2) {
                            return ((Argument)typeArguments.get(0)).getType() == beanType && ((Argument)typeArguments.get(1)).getType() == e.getClass();
                        }
                        return false;
                    }).findFirst();
                    TaskExceptionHandler<?, ?> finalHandler = mostSpecific.map(bd -> (TaskExceptionHandler)this.beanContext.getBean(bd.getBeanType(), qualifier)).orElse(this.taskExceptionHandler);
                    finalHandler.handle(bean, e);
                }
            };
            String cronExpr = (String)scheduledAnnotation.get((CharSequence)MEMBER_CRON, String.class, null);
            String fixedDelay = scheduledAnnotation.get((CharSequence)MEMBER_FIXED_DELAY, String.class).orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)cronExpr)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling cron task [{}] for method: {}", (Object)cronExpr, method);
                }
                taskScheduler.schedule(cronExpr, task);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)fixedRate)) {
                converted = this.conversionService.convert((Object)fixedRate, Duration.class);
                duration = (Duration)converted.orElseThrow(() -> new SchedulerConfigurationException(method, "Invalid fixed rate definition: " + fixedRate));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling fixed rate task [{}] for method: {}", (Object)duration, method);
                }
                scheduledFuture = taskScheduler.scheduleAtFixedRate(initialDelay, duration, task);
                this.scheduledTasks.add(scheduledFuture);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)fixedDelay)) {
                converted = this.conversionService.convert((Object)fixedDelay, Duration.class);
                duration = (Duration)converted.orElseThrow(() -> new SchedulerConfigurationException(method, "Invalid fixed delay definition: " + fixedDelay));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling fixed delay task [{}] for method: {}", (Object)duration, method);
                }
                scheduledFuture = taskScheduler.scheduleWithFixedDelay(initialDelay, duration, task);
                this.scheduledTasks.add(scheduledFuture);
                continue;
            }
            if (initialDelay != null) {
                ScheduledFuture<?> scheduledFuture2 = taskScheduler.schedule(initialDelay, task);
                this.scheduledTasks.add(scheduledFuture2);
                continue;
            }
            throw new SchedulerConfigurationException(method, "Failed to schedule task. Invalid definition");
        }
    }

    @Override
    public void close() {
        for (ScheduledFuture scheduledFuture : this.scheduledTasks) {
            if (scheduledFuture.isCancelled()) continue;
            scheduledFuture.cancel(false);
        }
    }
}

