/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;

@Internal
public class ObjectNodeConvertibleValues<V>
implements ConvertibleValues<V> {
    private final ObjectNode objectNode;
    private final ConversionService<?> conversionService;

    public ObjectNodeConvertibleValues(ObjectNode objectNode, ConversionService<?> conversionService) {
        this.objectNode = objectNode;
        this.conversionService = conversionService;
    }

    public Set<String> names() {
        Iterator fieldNames = this.objectNode.fieldNames();
        return CollectionUtils.iteratorToSet((Iterator)fieldNames);
    }

    public Collection<V> values() {
        ArrayList<JsonNode> values = new ArrayList<JsonNode>();
        for (JsonNode jsonNode : this.objectNode) {
            values.add(jsonNode);
        }
        return Collections.unmodifiableCollection(values);
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String fieldName = name.toString();
        JsonNode jsonNode = this.objectNode.get(fieldName);
        if (jsonNode == null) {
            return Optional.empty();
        }
        return this.conversionService.convert((Object)jsonNode, conversionContext);
    }
}

