/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config.yaml;

import grails.util.Environment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.grails.config.NavigableMap;
import org.grails.config.NavigableMapPropertySource;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

@Order(value=-2147483648)
public class YamlPropertySourceLoader
extends YamlProcessor
implements PropertySourceLoader {
    public String[] getFileExtensions() {
        return new String[]{"yml", "yaml"};
    }

    public List<PropertySource<?>> load(String name, Resource resource) throws IOException {
        return this.load(name, resource, Collections.emptyList());
    }

    public List<PropertySource<?>> load(String name, Resource resource, List<String> filteredKeys) throws IOException {
        this.setResources(new Resource[]{resource});
        this.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{properties -> {
            String profile = properties.getProperty("spring.profiles");
            return profile == null || profile.equalsIgnoreCase(System.getProperty("spring.profiles.active")) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
        }});
        List<Map<String, Object>> loaded = this.load();
        if (loaded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList propertySources = new ArrayList(loaded.size());
        NavigableMap propertySource = new NavigableMap();
        loaded.forEach(map -> {
            String currentEnvironment;
            Environment env = Environment.getCurrentEnvironment();
            String string = currentEnvironment = env != null ? env.getName() : null;
            if (currentEnvironment != null) {
                String prefix = "environments." + currentEnvironment + ".";
                Set environmentSpecificEntries = map.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toSet());
                for (String entry : environmentSpecificEntries) {
                    map.put(entry.substring(prefix.length()), map.get(entry));
                }
            }
            if (filteredKeys != null) {
                for (String filteredKey : filteredKeys) {
                    map.remove(filteredKey);
                }
            }
            propertySource.merge(map, true);
        });
        propertySources.add((PropertySource<?>)new NavigableMapPropertySource(name, propertySource));
        return propertySources;
    }

    public List<Map<String, Object>> load() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        this.process((properties, map) -> result.add(this.getFlattenedMap(map)));
        return result;
    }
}

