/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
class ExecutableElementParamInfo {
    private boolean validated = false;
    private final boolean requiresReflection;
    private final AnnotationMetadata metadata;
    private final Map<String, ParameterElement> parameters = new LinkedHashMap<String, ParameterElement>(10);
    private final Map<String, ClassElement> genericParameters = new LinkedHashMap<String, ClassElement>(10);
    private final Map<String, ClassElement> parameterTypes = new LinkedHashMap<String, ClassElement>(10);

    ExecutableElementParamInfo(boolean requiresReflection, AnnotationMetadata metadata) {
        this.requiresReflection = requiresReflection;
        this.metadata = metadata != null ? metadata : AnnotationMetadata.EMPTY_METADATA;
    }

    void addParameter(String paramName, ParameterElement classElement) {
        this.parameters.put(paramName, classElement);
        this.parameterTypes.put(paramName, classElement.getType());
        this.genericParameters.put(paramName, classElement.getGenericType());
    }

    Map<String, ParameterElement> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    Map<String, ClassElement> getParameterTypes() {
        return Collections.unmodifiableMap(this.parameterTypes);
    }

    Map<String, ClassElement> getGenericParameterTypes() {
        return Collections.unmodifiableMap(this.genericParameters);
    }

    Map<String, AnnotationMetadata> getParameterMetadata() {
        return this.getParameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ParameterElement)entry.getValue()).getAnnotationMetadata()));
    }

    boolean isRequiresReflection() {
        return this.requiresReflection;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.metadata;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }
}

