package org.springframework.uaa.client.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

import org.springframework.uaa.client.internal.JdkUrlTransmissionServiceImpl;

/**
 * Utility methods for dealing with Java Preferences objects.
 * 
 * @author Ben Alex
 * @since 1.0.1
 *
 */
public abstract class PreferencesUtils {

	private static final Class<PreferencesUtils> mutex = PreferencesUtils.class;
	
	/**
	 * Obtains the correct {@link Preferences} instance for the presented class. Importantly, it ensures any "Created user preferences
	 * directory" messages are not displayed.
	 * 
	 * @param clazz to obtain an preferences instance for (required)
	 * @return the correct {@link Preferences} instance (never null)
	 */
	public static Preferences getPreferencesFor(Class<?> clazz) {
		synchronized (mutex) {
			// Create the Preferences object, suppressing "Created user preferences directory" messages if there is no Java preferences directory
			Logger l = Logger.getLogger("java.util.prefs");
			Level original = l.getLevel();
			try {
				l.setLevel(Level.WARNING);
				return Preferences.userNodeForPackage(JdkUrlTransmissionServiceImpl.class);
			} finally {
				l.setLevel(original);
			}
		}
	}
}
