/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;

public class CMSEnvelopedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private Object _originatorInfo = null;
    private Object _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void setBEREncodeRecipients(boolean bl) {
        this._berEncodeRecipientSet = bl;
    }

    private DERInteger getVersion() {
        if (this._originatorInfo != null || this._unprotectedAttributes != null) {
            return new DERInteger(2);
        }
        return new DERInteger(0);
    }

    private OutputStream open(OutputStream outputStream, String string, KeyGenerator keyGenerator, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        String string3 = keyGenerator.getProvider().getName();
        SecretKey secretKey = keyGenerator.generateKey();
        AlgorithmParameters algorithmParameters = this.generateParameters(string, secretKey, string3);
        Iterator iterator = this.recipientInfs.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            CMSEnvelopedGenerator.RecipientInf recipientInf = (CMSEnvelopedGenerator.RecipientInf)iterator.next();
            try {
                aSN1EncodableVector.add((DEREncodable)recipientInf.toRecipientInfo(secretKey, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        return this.open(outputStream, string, secretKey, algorithmParameters, aSN1EncodableVector, string3);
    }

    protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameters algorithmParameters, ASN1EncodableVector aSN1EncodableVector, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        try {
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.envelopedData);
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            bERSequenceGenerator2.addObject((DEREncodable)this.getVersion());
            if (this._berEncodeRecipientSet) {
                bERSequenceGenerator2.getRawOutputStream().write(new BERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            } else {
                bERSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            }
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(string, string2);
            cipher.init(1, (Key)secretKey, algorithmParameters);
            BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
            bERSequenceGenerator3.addObject((DEREncodable)PKCSObjectIdentifiers.data);
            if (algorithmParameters == null) {
                algorithmParameters = cipher.getParameters();
            }
            AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(string, algorithmParameters);
            bERSequenceGenerator3.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(bERSequenceGenerator3.getRawOutputStream(), 0, false);
            CipherOutputStream cipherOutputStream = this._bufferSize != 0 ? new CipherOutputStream(bEROctetStringGenerator.getOctetOutputStream(new byte[this._bufferSize]), cipher) : new CipherOutputStream(bEROctetStringGenerator.getOctetOutputStream(), cipher);
            return new CmsEnvelopedDataOutputStream(cipherOutputStream, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    public OutputStream open(OutputStream outputStream, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        try {
            KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, string2);
            return this.open(outputStream, string, keyGenerator, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find key generation algorithm.", noSuchAlgorithmException);
        }
    }

    public OutputStream open(OutputStream outputStream, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        try {
            KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, string2);
            keyGenerator.init(n);
            return this.open(outputStream, string, keyGenerator, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find key generation algorithm.", noSuchAlgorithmException);
        }
    }

    private class CmsEnvelopedDataOutputStream
    extends OutputStream {
        private CipherOutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsEnvelopedDataOutputStream(CipherOutputStream cipherOutputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = cipherOutputStream;
            this._cGen = bERSequenceGenerator;
            this._envGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            this._envGen.close();
            this._cGen.close();
        }
    }
}

