/*
 * Decompiled with CFR 0.152.
 */
package sl.org.objectweb.asm.util;

import java.util.HashMap;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.util.ASMifierAbstractVisitor;
import sl.org.objectweb.asm.util.ASMifierAnnotationVisitor;

public class ASMifierMethodVisitor
extends ASMifierAbstractVisitor
implements MethodVisitor {
    public ASMifierMethodVisitor() {
        super("mv");
        this.labelNames = new HashMap();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = mv.visitAnnotationDefault();\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = mv.visitParameterAnnotation(").append(n).append(", ");
        this.appendConstant(string);
        this.buf.append(", ").append(bl).append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public void visitCode() {
        this.text.add("mv.visitCode();\n");
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.buf.setLength(0);
        switch (n) {
            case -1: 
            case 0: {
                this.declareFrameTypes(n2, objectArray);
                this.declareFrameTypes(n3, objectArray2);
                if (n == -1) {
                    this.buf.append("mv.visitFrame(Opcodes.F_NEW, ");
                } else {
                    this.buf.append("mv.visitFrame(Opcodes.F_FULL, ");
                }
                this.buf.append(n2).append(", new Object[] {");
                this.appendFrameTypes(n2, objectArray);
                this.buf.append("}, ").append(n3).append(", new Object[] {");
                this.appendFrameTypes(n3, objectArray2);
                this.buf.append('}');
                break;
            }
            case 1: {
                this.declareFrameTypes(n2, objectArray);
                this.buf.append("mv.visitFrame(Opcodes.F_APPEND,").append(n2).append(", new Object[] {");
                this.appendFrameTypes(n2, objectArray);
                this.buf.append("}, 0, null");
                break;
            }
            case 2: {
                this.buf.append("mv.visitFrame(Opcodes.F_CHOP,").append(n2).append(", null, 0, null");
                break;
            }
            case 3: {
                this.buf.append("mv.visitFrame(Opcodes.F_SAME, 0, null, 0, null");
                break;
            }
            case 4: {
                this.declareFrameTypes(1, objectArray2);
                this.buf.append("mv.visitFrame(Opcodes.F_SAME1, 0, null, 1, new Object[] {");
                this.appendFrameTypes(1, objectArray2);
                this.buf.append('}');
            }
        }
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitInsn(int n) {
        this.buf.setLength(0);
        this.buf.append("mv.visitInsn(").append(OPCODES[n]).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitIntInsn(").append(OPCODES[n]).append(", ").append(n == 188 ? TYPES[n2] : Integer.toString(n2)).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitVarInsn(").append(OPCODES[n]).append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int n, String string) {
        this.buf.setLength(0);
        this.buf.append("mv.visitTypeInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitFieldInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMethodInsn(").append(OPCODES[n]).append(", ");
        this.appendConstant(string);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int n, Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mv.visitJumpInsn(").append(OPCODES[n]).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mv.visitLabel(");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLdcInsn(");
        this.appendConstant(object);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitIincInsn(").append(n).append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        int n3;
        this.buf.setLength(0);
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.declareLabel(labelArray[n3]);
        }
        this.declareLabel(label);
        this.buf.append("mv.visitTableSwitchInsn(").append(n).append(", ").append(n2).append(", ");
        this.appendLabel(label);
        this.buf.append(", new Label[] {");
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.buf.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n3]);
        }
        this.buf.append(" });\n");
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        this.buf.setLength(0);
        for (n = 0; n < labelArray.length; ++n) {
            this.declareLabel(labelArray[n]);
        }
        this.declareLabel(label);
        this.buf.append("mv.visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.buf.append(", new int[] {");
        for (n = 0; n < nArray.length; ++n) {
            this.buf.append(n == 0 ? " " : ", ").append(nArray[n]);
        }
        this.buf.append(" }, new Label[] {");
        for (n = 0; n < labelArray.length; ++n) {
            this.buf.append(n == 0 ? " " : ", ");
            this.appendLabel(labelArray[n]);
        }
        this.buf.append(" });\n");
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMultiANewArrayInsn(");
        this.appendConstant(string);
        this.buf.append(", ").append(n).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.declareLabel(label2);
        this.declareLabel(label3);
        this.buf.append("mv.visitTryCatchBlock(");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ");
        this.appendLabel(label3);
        this.buf.append(", ");
        this.appendConstant(string);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLocalVariable(");
        this.appendConstant(string);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ").append(n).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLineNumber(").append(n).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMaxs(").append(n).append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    private void declareFrameTypes(int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof Label)) continue;
            this.declareLabel((Label)objectArray[i]);
        }
    }

    private void appendFrameTypes(int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.buf.append(", ");
            }
            if (objectArray[i] instanceof String) {
                this.appendConstant(objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                switch ((Integer)objectArray[i]) {
                    case 0: {
                        this.buf.append("Opcodes.TOP");
                        break;
                    }
                    case 1: {
                        this.buf.append("Opcodes.INTEGER");
                        break;
                    }
                    case 2: {
                        this.buf.append("Opcodes.FLOAT");
                        break;
                    }
                    case 3: {
                        this.buf.append("Opcodes.DOUBLE");
                        break;
                    }
                    case 4: {
                        this.buf.append("Opcodes.LONG");
                        break;
                    }
                    case 5: {
                        this.buf.append("Opcodes.NULL");
                        break;
                    }
                    case 6: {
                        this.buf.append("Opcodes.UNINITIALIZED_THIS");
                    }
                }
                continue;
            }
            this.appendLabel((Label)objectArray[i]);
        }
    }

    private void declareLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "l" + this.labelNames.size();
            this.labelNames.put(label, string);
            this.buf.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    private void appendLabel(Label label) {
        this.buf.append((String)this.labelNames.get(label));
    }
}

