/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.Asserts;

public class NameRegistry {
    private static int nextTypeId = 0;
    private static int size = 10;
    private static String[] allocatedIds = new String[size];

    private NameRegistry() {
    }

    public static void reset() {
        nextTypeId = 0;
        size = 10;
        allocatedIds = new String[size];
    }

    public static int getIdFor(String slashedClassName) {
        assert (Asserts.assertNotDotted(slashedClassName));
        int i = 0;
        while (i < nextTypeId) {
            if (allocatedIds[i].equals(slashedClassName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIdOrAllocateFor(String slashedClassName) {
        int id = NameRegistry.getIdFor(slashedClassName);
        if (id == -1) {
            id = NameRegistry.allocateId(slashedClassName);
        }
        return id;
    }

    private static synchronized int allocateId(String slashedClassName) {
        int id = NameRegistry.getIdFor(slashedClassName);
        if (id == -1) {
            if ((id = nextTypeId++) >= allocatedIds.length) {
                String[] newAllocatedIds = new String[size += 10];
                System.arraycopy(allocatedIds, 0, newAllocatedIds, 0, allocatedIds.length);
                allocatedIds = newAllocatedIds;
            }
            NameRegistry.allocatedIds[id] = slashedClassName;
        }
        return id;
    }

    public static String getTypenameById(int typeId) {
        if (typeId > size) {
            return null;
        }
        return allocatedIds[typeId];
    }
}

