/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.HashMap;
import java.util.Map;
import sl.org.objectweb.asm.ClassAdapter;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodAdapter;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;
import sl.org.objectweb.asm.Type;

public class ClassRenamer {
    public static byte[] rename(String dottedNewName, byte[] classbytes, String ... retargets) {
        ClassReader fileReader = new ClassReader(classbytes);
        RenameAdapter renameAdapter = new RenameAdapter(dottedNewName, retargets);
        fileReader.accept(renameAdapter, 0);
        byte[] renamed = renameAdapter.getBytes();
        return renamed;
    }

    static class RenameAdapter
    extends ClassAdapter
    implements Opcodes {
        private ClassWriter cw;
        private String oldname;
        private String newname;
        private Map<String, String> retargets = new HashMap<String, String>();

        public RenameAdapter(String newname, String[] retargets) {
            super(new ClassWriter(0));
            this.cw = (ClassWriter)this.cv;
            this.newname = newname.replace('.', '/');
            if (retargets != null) {
                String[] stringArray = retargets;
                int n = retargets.length;
                int n2 = 0;
                while (n2 < n) {
                    String retarget = stringArray[n2];
                    int i = retarget.indexOf(":");
                    this.retargets.put(retarget.substring(0, i).replace('.', '/'), retarget.substring(i + 1).replace('.', '/'));
                    ++n2;
                }
            }
        }

        public byte[] getBytes() {
            return this.cw.toByteArray();
        }

        private String retargetIfNecessary(String string) {
            String value = this.retargets.get(string);
            return value == null ? string : value;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.oldname = name;
            if (superName != null) {
                superName = this.retargetIfNecessary(superName);
            }
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    interfaces[i] = this.retargetIfNecessary(interfaces[i]);
                    ++i;
                }
            }
            super.visit(version, access, this.newname, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            if (descriptor.indexOf(this.oldname) != -1) {
                descriptor = descriptor.replace(this.oldname, this.newname);
            } else {
                for (String s : this.retargets.keySet()) {
                    if (descriptor.indexOf(s) == -1) continue;
                    descriptor = descriptor.replace(s, this.retargets.get(s));
                }
            }
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            return new RenameMethodAdapter(mv, this.oldname, this.newname);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (desc.indexOf(this.oldname) != -1) {
                desc = desc.replace(this.oldname, this.newname);
            } else {
                for (String s : this.retargets.keySet()) {
                    if (desc.indexOf(s) == -1) continue;
                    desc = desc.replace(s, this.retargets.get(s));
                }
            }
            return super.visitField(access, name, desc, signature, value);
        }

        class RenameMethodAdapter
        extends MethodAdapter
        implements Opcodes {
            String oldname;
            String newname;

            public RenameMethodAdapter(MethodVisitor mv, String oldname, String newname) {
                super(mv);
                this.oldname = oldname;
                this.newname = newname;
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (owner.equals(this.oldname)) {
                    owner = this.newname;
                } else {
                    String retarget = (String)RenameAdapter.this.retargets.get(owner);
                    if (retarget != null) {
                        owner = retarget;
                    }
                }
                desc = desc.indexOf(this.oldname) != -1 ? desc.replace(this.oldname, this.newname) : this.checkIfShouldBeRewritten(desc);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitTypeInsn(int opcode, String type) {
                if (type.equals(this.oldname)) {
                    type = this.newname;
                } else {
                    String retarget = (String)RenameAdapter.this.retargets.get(type);
                    if (retarget != null) {
                        type = retarget;
                    } else if (type.startsWith("[") && type.indexOf(this.oldname) != -1) {
                        type = type.replaceFirst(this.oldname, this.newname);
                    }
                }
                this.mv.visitTypeInsn(opcode, type);
            }

            public void visitLdcInsn(Object obj) {
                if (obj instanceof Type) {
                    Type t = (Type)obj;
                    String s = t.getInternalName();
                    String retarget = (String)RenameAdapter.this.retargets.get(s);
                    if (retarget != null) {
                        this.mv.visitLdcInsn(Type.getObjectType(retarget));
                    } else {
                        this.mv.visitLdcInsn(obj);
                    }
                } else if (obj instanceof String) {
                    String s = (String)obj;
                    String retarget = (String)RenameAdapter.this.retargets.get(s.replace('.', '/'));
                    if (retarget != null) {
                        this.mv.visitLdcInsn(retarget.replace('/', '.'));
                    } else {
                        String oldnameDotted = this.oldname.replace('/', '.');
                        if (s.equals(oldnameDotted)) {
                            String nname = this.newname.replace('/', '.');
                            this.mv.visitLdcInsn(nname);
                            return;
                        }
                        if (s.startsWith("[") && s.indexOf(oldnameDotted) != -1) {
                            this.mv.visitLdcInsn(s.replaceFirst(oldnameDotted, this.newname.replace('/', '.')));
                            return;
                        }
                        this.mv.visitLdcInsn(obj);
                    }
                } else {
                    this.mv.visitLdcInsn(obj);
                }
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                owner = owner.equals(this.oldname) ? this.newname : RenameAdapter.this.retargetIfNecessary(owner);
                desc = desc.indexOf(this.oldname) != -1 ? desc.replace(this.oldname, this.newname) : this.checkIfShouldBeRewritten(desc);
                this.mv.visitMethodInsn(opcode, owner, name, desc);
            }

            private String checkIfShouldBeRewritten(String desc) {
                for (String s : RenameAdapter.this.retargets.keySet()) {
                    if (desc.indexOf(s) == -1) continue;
                    desc = desc.replace(s, (CharSequence)RenameAdapter.this.retargets.get(s));
                }
                return desc;
            }
        }
    }
}

