/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.events;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.context.ApplicationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoTimestampEventListener
extends AbstractPersistenceEventListener
implements MappingContext.Listener {
    public static final String DATE_CREATED_PROPERTY = "dateCreated";
    public static final String LAST_UPDATED_PROPERTY = "lastUpdated";
    private Map<PersistentEntity, Boolean> entitiesWithDateCreated = new ConcurrentHashMap<PersistentEntity, Boolean>();
    private Map<PersistentEntity, Boolean> entitiesWithLastUpdated = new ConcurrentHashMap<PersistentEntity, Boolean>();

    public AutoTimestampEventListener(Datastore datastore) {
        super(datastore);
        for (PersistentEntity persistentEntity : datastore.getMappingContext().getPersistentEntities()) {
            this.storeDateCreatedInfo(persistentEntity);
            this.storeLastUpdatedInfo(persistentEntity);
        }
        datastore.getMappingContext().addMappingContextListener((MappingContext.Listener)this);
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        if (event instanceof PreInsertEvent) {
            this.beforeInsert(event.getEntity(), event.getEntityAccess());
        } else if (event instanceof PreUpdateEvent) {
            this.beforeUpdate(event.getEntity(), event.getEntityAccess());
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreInsertEvent.class.isAssignableFrom(eventType) || PreUpdateEvent.class.isAssignableFrom(eventType);
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess ea) {
        if (this.hasDateCreated(entity)) {
            Date now = new Date();
            ea.setProperty(DATE_CREATED_PROPERTY, (Object)now);
            if (this.hasLastupdated(entity)) {
                ea.setProperty(LAST_UPDATED_PROPERTY, (Object)now);
            }
        }
        return true;
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess ea) {
        if (this.hasLastupdated(entity)) {
            ea.setProperty(LAST_UPDATED_PROPERTY, (Object)new Date());
        }
        return true;
    }

    private boolean hasLastupdated(PersistentEntity entity) {
        return this.entitiesWithLastUpdated.containsKey(entity) && this.entitiesWithLastUpdated.get(entity) != false;
    }

    private boolean hasDateCreated(PersistentEntity entity) {
        return this.entitiesWithDateCreated.containsKey(entity) && this.entitiesWithDateCreated.get(entity) != false;
    }

    private void storeLastUpdatedInfo(PersistentEntity persistentEntity) {
        this.entitiesWithLastUpdated.put(persistentEntity, persistentEntity.hasProperty(LAST_UPDATED_PROPERTY, Date.class));
    }

    private void storeDateCreatedInfo(PersistentEntity persistentEntity) {
        this.entitiesWithDateCreated.put(persistentEntity, persistentEntity.hasProperty(DATE_CREATED_PROPERTY, Date.class));
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.storeDateCreatedInfo(entity);
        this.storeLastUpdatedInfo(entity);
    }
}

