/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.html.HTMLProcessor;
import com.opensymphony.module.sitemesh.html.State;
import com.opensymphony.module.sitemesh.html.StateTransitionRule;
import com.opensymphony.module.sitemesh.html.TagRule;
import com.opensymphony.module.sitemesh.html.rules.BodyTagRule;
import com.opensymphony.module.sitemesh.html.rules.ContentBlockExtractingRule;
import com.opensymphony.module.sitemesh.html.rules.FramesetRule;
import com.opensymphony.module.sitemesh.html.rules.HeadExtractingRule;
import com.opensymphony.module.sitemesh.html.rules.HtmlAttributesRule;
import com.opensymphony.module.sitemesh.html.rules.MSOfficeDocumentPropertiesRule;
import com.opensymphony.module.sitemesh.html.rules.MetaTagRule;
import com.opensymphony.module.sitemesh.html.rules.PageBuilder;
import com.opensymphony.module.sitemesh.html.rules.ParameterExtractingRule;
import com.opensymphony.module.sitemesh.html.rules.TitleExtractingRule;
import com.opensymphony.module.sitemesh.html.util.CharArray;
import com.opensymphony.module.sitemesh.parser.HTMLPageParser;
import java.io.IOException;
import org.codehaus.groovy.grails.web.sitemesh.GrailsTokenizedHTMLPage;

public class GrailsHTMLPageParser
extends HTMLPageParser {
    public Page parse(char[] data) throws IOException {
        CharArray head = new CharArray(64);
        CharArray body = new CharArray(4096);
        GrailsTokenizedHTMLPage page = new GrailsTokenizedHTMLPage(data, body, head);
        HTMLProcessor processor = new HTMLProcessor(data, body);
        State html = processor.defaultState();
        html.addRule((TagRule)new HeadExtractingRule(head));
        html.addRule((TagRule)new BodyTagRule((PageBuilder)page, body));
        html.addRule((TagRule)new TitleExtractingRule((PageBuilder)page));
        html.addRule((TagRule)new FramesetRule((PageBuilder)page));
        this.addUserDefinedRules(html, (PageBuilder)page);
        processor.process();
        return page;
    }

    protected void addUserDefinedRules(State html, PageBuilder page) {
        State xml = new State();
        html.addRule((TagRule)new StateTransitionRule("xml", xml));
        html.addRule((TagRule)new HtmlAttributesRule(page));
        html.addRule((TagRule)new MetaTagRule(page));
        html.addRule((TagRule)new ParameterExtractingRule(page));
        html.addRule((TagRule)new ContentBlockExtractingRule(page));
        xml.addRule((TagRule)new MSOfficeDocumentPropertiesRule(page));
    }
}

