/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.grails.web.mapping.DefaultLinkGenerator;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingLinkGenerator
extends DefaultLinkGenerator {
    private static final int DEFAULT_MAX_WEIGHTED_CAPACITY = 5000;
    public static final String LINK_PREFIX = "link";
    public static final String RESOURCE_PREFIX = "resource";
    public static final String USED_ATTRIBUTES_SUFFIX = "-used-attributes";
    public static final String EMPTY_MAP_STRING = "[:]";
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";
    private static final String COMMA_SEPARATOR = ", ";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String THIS_MAP = "(this Map)";
    private static final String URL_ATTRIBUTE = "url";
    private static final String URI_ATTRIBUTE = "uri";
    private Map<String, Object> linkCache;

    public CachingLinkGenerator(String serverBaseURL, String contextPath) {
        super(serverBaseURL, contextPath);
        this.linkCache = this.createDefaultCache();
    }

    public CachingLinkGenerator(String serverBaseURL) {
        super(serverBaseURL);
        this.linkCache = this.createDefaultCache();
    }

    public CachingLinkGenerator(String serverBaseURL, Map<String, Object> linkCache) {
        super(serverBaseURL);
        this.linkCache = linkCache;
    }

    public CachingLinkGenerator(String serverBaseURL, String contextPath, Map<String, Object> linkCache) {
        super(serverBaseURL, contextPath);
        this.linkCache = linkCache;
    }

    @Override
    public String link(Map attrs, String encoding) {
        if (!this.isCacheable(attrs)) {
            return super.link(attrs, encoding);
        }
        String key = this.makeKey(LINK_PREFIX, attrs);
        Object resourceLink = this.linkCache.get(key);
        if (resourceLink == null) {
            resourceLink = super.link(attrs, encoding);
            this.linkCache.put(key, resourceLink);
        }
        return resourceLink.toString();
    }

    private boolean isCacheable(Map attrs) {
        Object urlAttr = attrs.get(URL_ATTRIBUTE);
        if (urlAttr instanceof Map) {
            return this.isCacheable((Map)urlAttr);
        }
        return attrs.get("controller") != null || attrs.get("action") != null || urlAttr != null || attrs.get(URI_ATTRIBUTE) != null;
    }

    private void appendMapKey(StringBuilder buffer, Map map) {
        if (map == null || map.isEmpty()) {
            buffer.append(EMPTY_MAP_STRING);
        }
        buffer.append(OPENING_BRACKET);
        boolean first = true;
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = o;
            Object value = entry.getValue();
            if (value == null) continue;
            first = this.appendCommaIfNotFirst(buffer, first);
            Object key = entry.getKey();
            if ("action".equals(key) && map.get("controller") == null) {
                this.appendKeyValue(buffer, map, "controller", this.getRequestStateLookupStrategy().getControllerName());
                this.appendCommaIfNotFirst(buffer, false);
            }
            this.appendKeyValue(buffer, map, key, value);
        }
        buffer.append(CLOSING_BRACKET);
    }

    private boolean appendCommaIfNotFirst(StringBuilder buffer, boolean first) {
        if (first) {
            first = false;
        } else {
            buffer.append(COMMA_SEPARATOR);
        }
        return first;
    }

    private void appendKeyValue(StringBuilder buffer, Map map, Object key, Object value) {
        buffer.append(key).append(KEY_VALUE_SEPARATOR);
        if (value == map) {
            buffer.append(THIS_MAP);
        } else {
            buffer.append(DefaultGroovyMethods.toString((Object)value));
        }
    }

    @Override
    public String resource(Map attrs) {
        String key = this.makeKey(RESOURCE_PREFIX, attrs);
        Object resourceLink = this.linkCache.get(key);
        if (resourceLink == null) {
            resourceLink = super.resource(attrs);
            this.linkCache.put(key, resourceLink);
        }
        return resourceLink.toString();
    }

    protected String makeKey(String prefix, Map attrs) {
        GrailsWebRequest webRequest;
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (this.getConfiguredServerBaseURL() == null && this.isAbsolute(attrs) && (webRequest = GrailsWebRequest.lookup()) != null) {
            sb.append(webRequest.getBaseUrl());
        }
        this.appendMapKey(sb, attrs);
        return sb.toString();
    }

    private ConcurrentLinkedHashMap<String, Object> createDefaultCache() {
        return new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(5000).build();
    }

    public void clearCache() {
        this.linkCache.clear();
    }
}

